/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.app;

import java.io.File;
import java.util.function.Supplier;
import org.teamapps.server.jetty.embedded.TeamAppsJettyEmbeddedServer;
import org.teamapps.udb.app.AccessController;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.login.LoginWindow;
import org.teamapps.webcontroller.WebController;

public class WebServer {
    private int port = 8080;
    private File webAppPath;
    private AccessController accessController;
    private Supplier<Component> componentSupplier;
    private final WebController webController = c -> c.addRootPanel().setContent(this.componentSupplier.get());

    public WebController getWebController() {
        return this.webController;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAccessController(AccessController accessController) {
        this.accessController = accessController;
    }

    public void setWebAppPath(File webAppPath) {
        this.webAppPath = webAppPath;
    }

    public void startServer(Supplier<Component> applicationSupplier) throws Exception {
        this.componentSupplier = this.wrapComponentSupplier(applicationSupplier);
        TeamAppsJettyEmbeddedServer server = new TeamAppsJettyEmbeddedServer(this.webController, this.webAppPath, this.port);
        server.start();
    }

    private Supplier<Component> wrapComponentSupplier(Supplier<Component> applicationSupplier) {
        if (this.accessController == null) {
            return applicationSupplier;
        }
        return () -> {
            VerticalLayout layout = new VerticalLayout();
            LoginWindow loginWindow = new LoginWindow();
            loginWindow.onLogin.addListener(() -> this.lambda$wrapComponentSupplier$1(loginWindow, layout, (Supplier)applicationSupplier));
            layout.addComponentFillRemaining((Component)loginWindow.getElegantPanel());
            return layout;
        };
    }

    private /* synthetic */ void lambda$wrapComponentSupplier$1(LoginWindow loginWindow, VerticalLayout layout, Supplier applicationSupplier) {
        if (this.accessController.grantAccess(loginWindow.getLogin(), loginWindow.getPassword())) {
            layout.removeAllComponents();
            layout.addComponentFillRemaining((Component)applicationSupplier.get());
        } else {
            loginWindow.setError();
        }
    }
}

