/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.table.AbstractTableModel;
import org.teamapps.ux.component.table.TableModel;

public class TableModelBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    protected TableModelBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
    }

    public TableModel<ENTITY> createTableModel() {
        AbstractTableModel tableModel = new AbstractTableModel<ENTITY>(){
            private List<ENTITY> entities;
            private Sorting lastSorting;

            public int getCount() {
                return (Integer)TableModelBuilder.this.getModelBuilderFactory().getRecordCount().get();
            }

            public List<ENTITY> getRecords(int startIndex, int length, Sorting sorting) {
                if (this.entities != null || sorting != this.lastSorting) {
                    if (sorting == null || sorting.getFieldName() == null) {
                        this.entities = TableModelBuilder.this.getModelBuilderFactory().getEntities(TableModelBuilder.this.getModelBuilderFactory().getFinalBitSet());
                    } else {
                        org.teamapps.universaldb.query.Sorting convertedSorting = TableModelBuilder.this.getModelBuilderFactory().convertSorting(sorting);
                        this.entities = TableModelBuilder.this.getModelBuilderFactory().getFinalQuery().execute(sorting.getFieldName(), sorting.getSorting() == SortDirection.ASC, new String[0]);
                    }
                    this.lastSorting = sorting;
                }
                return this.entities.stream().skip(startIndex).limit(length).collect(Collectors.toList());
            }
        };
        this.getModelBuilderFactory().onFinalDataChanged.addListener(() -> TableModelBuilder.lambda$createTableModel$0((AbstractTableModel)tableModel));
        return tableModel;
    }

    private static /* synthetic */ void lambda$createTableModel$0(AbstractTableModel tableModel) {
        tableModel.onAllDataChanged.fire();
    }
}

