/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.perspectve;

import java.util.HashMap;
import java.util.Map;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.Icon;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.InfiniteItemViewBuilder;
import org.teamapps.udb.MapBuilder;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.TableBuilder;
import org.teamapps.udb.TimeGraphBuilder;
import org.teamapps.udb.decider.DeciderSet;
import org.teamapps.udb.form.FormBuilder;
import org.teamapps.udb.grouping.GroupingView;
import org.teamapps.udb.perspectve.ViewDefinition;
import org.teamapps.udb.perspectve.ViewType;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.infiniteitemview.InfiniteItemView2;
import org.teamapps.ux.component.template.Template;

public class PerspectiveBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    private final EntityBuilder<ENTITY> entityBuilder;
    private final DeciderSet<ENTITY> deciderSet;
    private Map<ViewType, ViewDefinition<ENTITY>> views = new HashMap<ViewType, ViewDefinition<ENTITY>>();
    private Perspective perspective;

    public PerspectiveBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory, EntityBuilder<ENTITY> entityBuilder, DeciderSet<ENTITY> deciderSet) {
        super(modelBuilderFactory);
        this.entityBuilder = entityBuilder;
        this.deciderSet = deciderSet;
    }

    public ViewDefinition<ENTITY> addView(ViewType viewType, String title, Icon icon) {
        return this.addView(new ViewDefinition(viewType, this.getModelBuilderFactory(), title, icon));
    }

    public ViewDefinition<ENTITY> addView(ViewType viewType, String layoutPosition, String title, Icon icon, boolean displayInitially) {
        return this.addView(new ViewDefinition(viewType, this.getModelBuilderFactory(), layoutPosition, title, icon, displayInitially));
    }

    private ViewDefinition<ENTITY> addView(ViewDefinition<ENTITY> viewDefinition) {
        this.views.put(viewDefinition.getViewType(), viewDefinition);
        return viewDefinition;
    }

    public ViewDefinition<ENTITY> addTableView(String title, Icon icon) {
        return this.addView(new ViewDefinition(ViewType.TABLE, this.getModelBuilderFactory(), title, icon));
    }

    public ViewDefinition<ENTITY> addFormView(String title, Icon icon) {
        return this.addView(new ViewDefinition(ViewType.FORM, this.getModelBuilderFactory(), title, icon));
    }

    public ViewDefinition<ENTITY> addTimeGraphView(String title, Icon icon) {
        return this.addView(new ViewDefinition(ViewType.TIME_GRAPH, this.getModelBuilderFactory(), title, icon));
    }

    public ViewDefinition<ENTITY> addGroupingView(String title, Icon icon) {
        return this.addView(new ViewDefinition(ViewType.GROUPING_VIEW, this.getModelBuilderFactory(), title, icon));
    }

    public ViewDefinition<ENTITY> addInfiniteItemView(String layoutPosition, String title, Icon icon, boolean displayInitially, Template template, PropertyExtractor<ENTITY> propertyExtractor, int itemWidth, int itemHeight) {
        return this.addView(new ViewDefinition(ViewType.ITEM_VIEW, this.getModelBuilderFactory(), layoutPosition, title, icon, displayInitially, template, propertyExtractor, itemWidth, itemHeight));
    }

    public ViewDefinition<ENTITY> addMapView(String layoutPosition, String title, Icon icon, boolean displayInitially, String latitudeFieldName, String longitudeFieldName) {
        ViewDefinition<ENTITY> viewDefinition = this.addView(ViewType.MAP, layoutPosition, title, icon, displayInitially);
        viewDefinition.setLocationFieldNames(latitudeFieldName, longitudeFieldName);
        return viewDefinition;
    }

    public PerspectiveBuilder<ENTITY> addDefaultViews() {
        this.addTableView("Table", (Icon)MaterialIcon.LIST);
        this.addFormView("Form", (Icon)MaterialIcon.EDIT);
        this.addTimeGraphView("Time graph", (Icon)MaterialIcon.TIMELINE);
        this.addGroupingView("Grouping", (Icon)MaterialIcon.GROUP);
        return this;
    }

    private void creatUi() {
        this.perspective = Perspective.createPerspective();
        ModelBuilderFactory<ENTITY> factory = this.getModelBuilderFactory();
        for (ViewDefinition<ENTITY> viewDefinition : this.views.values()) {
            if (!viewDefinition.isDisplayInitially()) continue;
            View view = viewDefinition.createView();
            this.perspective.addView(view);
            switch (viewDefinition.getViewType()) {
                case TABLE: {
                    TableBuilder<ENTITY> tableBuilder = factory.createTableBuilder();
                    tableBuilder.addFields(viewDefinition.getFields());
                    tableBuilder.createAndAttachToViewWithHeaderField(view);
                    break;
                }
                case ITEM_VIEW: {
                    InfiniteItemViewBuilder itemViewBuilder = factory.createInfiniteItemViewBuilder();
                    InfiniteItemView2 itemView = itemViewBuilder.createAndAttachToViewWithHeaderField(view, viewDefinition.getTemplate(), viewDefinition.getItemWidth(), viewDefinition.getItemHeight());
                    itemView.setItemPropertyExtractor(viewDefinition.getPropertyExtractor());
                    break;
                }
                case FORM: {
                    FormBuilder<ENTITY> formBuilder = factory.createFormBuilder(this.entityBuilder, this.deciderSet);
                    formBuilder.addFields(viewDefinition.getFields());
                    formBuilder.createAndAttachToViewWithToolbarButtons(view);
                    break;
                }
                case TIME_GRAPH: {
                    TimeGraphBuilder<ENTITY> timeGraphBuilder = factory.createTimeGraphBuilder();
                    timeGraphBuilder.addFields(viewDefinition.getFields());
                    timeGraphBuilder.createAndAttachToViewWithHeaderField(view);
                    break;
                }
                case MAP: {
                    MapBuilder mapBuilder = factory.createMapBuilder();
                    if (viewDefinition.getLatitudeFieldName() == null || viewDefinition.getLongitudeFieldName() == null) break;
                    mapBuilder.setFields(viewDefinition.getLatitudeFieldName(), viewDefinition.getLongitudeFieldName());
                    break;
                }
                case GROUPING_VIEW: {
                    GroupingView groupingView = factory.createGroupingView();
                    groupingView.createAndAttachToViewWithHeaderField(view);
                }
            }
        }
    }

    public Perspective getOrCreatePerspective() {
        if (this.perspective == null) {
            this.creatUi();
        }
        return this.perspective;
    }
}

