/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.icon.TeamAppsIconBundle;

public class HeaderFieldBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    protected HeaderFieldBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
    }

    public void attachSearchHeaderField(View view) {
        view.getPanel().setRightHeaderField((AbstractField)this.createFullTextSearchHeaderField());
        view.getPanel().setRightHeaderFieldIcon(this.getIcon(TeamAppsIconBundle.SEARCH.getKey()));
    }

    public TextField createFullTextSearchHeaderField() {
        TextField textField = new TextField();
        textField.setEmptyText(this.getLocalized(TeamAppsDictionary.SEARCH___.getKey(), new Object[0]));
        textField.setShowClearButton(true);
        textField.setEditingMode(FieldEditingMode.EDITABLE_IF_FOCUSED);
        textField.setMinWidth(Length.ofPixels((int)75));
        textField.setMaxWidth(Length.ofPixels((int)250));
        textField.onTextInput.addListener(query -> this.getModelBuilderFactory().onFullTextQueryFilterChanged.fire(query));
        return textField;
    }

    public void setSearchHeaderField(View view) {
        HeaderFieldBuilder headerFieldBuilder = this.getModelBuilderFactory().createHeaderFieldBuilder();
        headerFieldBuilder.attachSearchHeaderField(view);
    }

    public void setHeaderTitleHandler(View view, String viewTitle) {
        this.getModelBuilderFactory().getRecordCount().onChanged().addListener(count -> view.getPanel().setTitle(viewTitle + " (" + count + ")"));
    }
}

