/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.Arrays;
import java.util.HashSet;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.FieldInfo;
import org.teamapps.udb.HeaderFieldBuilder;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.form.FormField;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.table.TableModel;

public class TableBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    protected TableBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
    }

    private TableColumn<ENTITY> createColumn(FieldInfo fieldInfo) {
        ColumnIndex columnIndex = this.getModelBuilderFactory().getTableIndex().getColumnIndex(fieldInfo.getName());
        AbstractField field = FormField.createField(columnIndex, fieldInfo.getTitle());
        if (field != null) {
            return new TableColumn(fieldInfo.getName(), fieldInfo.getIcon(), fieldInfo.getTitle(), field);
        }
        return null;
    }

    public Table<ENTITY> build(String ... fieldNames) {
        HashSet<String> fields = new HashSet<String>(Arrays.asList(fieldNames));
        TableModel tableModel = this.getModelBuilderFactory().createTableModelBuilder().createTableModel();
        Table table = new Table();
        table.setModel(tableModel);
        for (FieldInfo fieldInfo : this.getModelBuilderFactory().getFieldInfos()) {
            TableColumn<ENTITY> column;
            if (!fields.isEmpty() && !fields.contains(fieldInfo.getName()) || (column = this.createColumn(fieldInfo)) == null) continue;
            table.addColumn(column);
        }
        table.onRowSelected.addListener(entity -> this.getModelBuilderFactory().onRecordSelected.fire(entity));
        return table;
    }

    public Table<ENTITY> createAndAttachToViewWithHeaderField(View view, String viewTitle, String ... fieldNames) {
        Table<ENTITY> table = this.build(fieldNames);
        view.setComponent(table);
        HeaderFieldBuilder headerFieldBuilder = this.getModelBuilderFactory().createHeaderFieldBuilder();
        headerFieldBuilder.setSearchHeaderField(view);
        headerFieldBuilder.setHeaderTitleHandler(view, viewTitle);
        return table;
    }
}

