/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.FieldInfo;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.TimeGraphModelBuilder;
import org.teamapps.udb.filter.TimeIntervalFilter;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartDataDisplayGroup;
import org.teamapps.ux.component.timegraph.LineChartLine;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.timegraph.TimeGraphModel;

public class TimeGraphBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    public static final String BASE_DATA_SERIES = "baseData";
    public static final String GEO_FILTER_SERIES = "geoData";
    public static final String GROUP_FILTER_SERIES = "groupData";
    public static final String FULL_TEXT_DATA_SERIES = "fullTextData";
    private ScaleType scaleType = ScaleType.LOG10;
    private LineChartLine chartLineBase;
    private LineChartLine chartLineGroupingFilter;
    private LineChartLine chartLineGeoFilter;
    private LineChartLine chartLineFullTextFilter;
    private List<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();

    protected TimeGraphBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
        this.setChartLines();
    }

    public TimeGraphBuilder<ENTITY> setFieldName(String fieldName) {
        this.fieldInfos.clear();
        this.addFieldInfo(new FieldInfo(fieldName, fieldName));
        return this;
    }

    public TimeGraphBuilder<ENTITY> addFieldInfo(FieldInfo fieldInfo) {
        this.fieldInfos.add(fieldInfo);
        return this;
    }

    private String getFirstFieldName() {
        if (!this.fieldInfos.isEmpty()) {
            return this.fieldInfos.get(0).getName();
        }
        if (this.getModelBuilderFactory().getTableIndex().getColumnIndex("metaCreationDate") != null) {
            return "metaCreationDate";
        }
        return this.getDateFields().get(0);
    }

    private void setChartLines() {
        this.chartLineBase = this.createChartLine(BASE_DATA_SERIES, Color.MATERIAL_BLUE_700);
        this.chartLineGeoFilter = this.createChartLine(GEO_FILTER_SERIES, Color.MATERIAL_RED_700);
        this.chartLineGroupingFilter = this.createChartLine(GROUP_FILTER_SERIES, Color.MATERIAL_GREEN_800);
        this.chartLineFullTextFilter = this.createChartLine(FULL_TEXT_DATA_SERIES, Color.MATERIAL_AMBER_700);
    }

    public LineChartLine createChartLine(String lineName, Color color) {
        LineChartLine line = new LineChartLine(lineName, LineChartCurveType.MONOTONE, 0.5f, color, color.withAlpha(0.05f));
        line.setAreaColorScaleMin(color.withAlpha(0.05f));
        line.setAreaColorScaleMax(color.withAlpha(0.5f));
        line.setYScaleType(this.scaleType);
        line.setYScaleZoomMode(LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO);
        return line;
    }

    public TimeGraph build() {
        TimeGraphModelBuilder modelBuilder = new TimeGraphModelBuilder(this.getModelBuilderFactory());
        String fieldName = this.getFirstFieldName();
        TimeGraphModel timeGraphModel = modelBuilder.build(fieldName);
        TimeGraph timeGraph = new TimeGraph(timeGraphModel);
        this.updateLines(timeGraph);
        this.getModelBuilderFactory().onGroupingDataChanged.addListener(() -> this.updateLines(timeGraph));
        this.getModelBuilderFactory().onFinalDataChanged.addListener(() -> this.updateLines(timeGraph));
        timeGraph.onIntervalSelected.addListener(interval -> this.getModelBuilderFactory().onTimeIntervalFilterChanged.fire((Object)(interval == null ? null : new TimeIntervalFilter(fieldName, interval.getMin(), interval.getMax()))));
        return timeGraph;
    }

    private void updateLines(TimeGraph timeGraph) {
        LineChartDataDisplayGroup lineChartDataDisplayGroup = new LineChartDataDisplayGroup();
        lineChartDataDisplayGroup.setYScaleType(this.scaleType);
        lineChartDataDisplayGroup.setYZeroLineVisible(false);
        lineChartDataDisplayGroup.setYScaleZoomMode(LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO);
        lineChartDataDisplayGroup.setYAxisColor(Color.BLACK);
        ArrayList<LineChartLine> lines = new ArrayList<LineChartLine>();
        lines.add(this.chartLineBase);
        lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.chartLineBase);
        if (this.getModelBuilderFactory().getGeoFilter() != null) {
            lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.chartLineGeoFilter);
            lines.add(this.chartLineGeoFilter);
        }
        if (this.getModelBuilderFactory().getGroupFilter() != null) {
            lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.chartLineGroupingFilter);
            lines.add(this.chartLineGroupingFilter);
        }
        if (this.getModelBuilderFactory().getFullTextQuery() != null && !this.getModelBuilderFactory().getFullTextQuery().isBlank()) {
            lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.chartLineFullTextFilter);
            lines.add(this.chartLineFullTextFilter);
        }
        timeGraph.setLines(lines);
    }

    private List<String> getDateFields() {
        return this.getModelBuilderFactory().getTableIndex().getColumnIndices().stream().filter(column -> column.getColumnType() == ColumnType.TIMESTAMP || column.getColumnType() == ColumnType.DATE_TIME || column.getColumnType() == ColumnType.LOCAL_DATE || column.getColumnType() == ColumnType.DATE).map(column -> column.getName()).collect(Collectors.toList());
    }

    public TimeGraphBuilder<ENTITY> setScaleType(boolean logarithmic) {
        this.scaleType = logarithmic ? ScaleType.LOG10 : ScaleType.LINEAR;
        return this;
    }

    public LineChartLine getChartLineBase() {
        return this.chartLineBase;
    }

    public TimeGraphBuilder<ENTITY> setChartLineBase(LineChartLine chartLineBase) {
        this.chartLineBase = chartLineBase;
        return this;
    }

    public LineChartLine getChartLineGroupingFilter() {
        return this.chartLineGroupingFilter;
    }

    public TimeGraphBuilder<ENTITY> setChartLineGroupingFilter(LineChartLine chartLineGroupingFilter) {
        this.chartLineGroupingFilter = chartLineGroupingFilter;
        return this;
    }

    public LineChartLine getChartLineFullTextFilter() {
        return this.chartLineFullTextFilter;
    }

    public TimeGraphBuilder<ENTITY> setChartLineFullTextFilter(LineChartLine chartLineFullTextFilter) {
        this.chartLineFullTextFilter = chartLineFullTextFilter;
        return this;
    }
}

