/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.form;

import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.icons.api.Icon;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.datetime.InstantDateField;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.datetime.InstantTimeField;
import org.teamapps.ux.component.field.datetime.LocalDateField;

public class FormField<ENTITY extends Entity, VALUE> {
    private final String name;
    private final ColumnIndex index;
    private String title;
    private Icon icon;
    private boolean editable = true;
    private boolean required;
    private boolean customField;
    private AbstractField<VALUE> field;
    private ValueExtractor<ENTITY> valueExtractor;
    private ValueInjector<ENTITY, VALUE> valueInjector;

    protected FormField(String name, ColumnIndex index) {
        this.name = name;
        this.index = index;
    }

    public FormField(String name) {
        this.name = name;
        this.index = null;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public FormField<ENTITY, VALUE> setTitle(String title) {
        this.title = title;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public FormField<ENTITY, VALUE> setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public FormField<ENTITY, VALUE> setEditable(boolean editable) {
        this.editable = editable;
        this.field.setEditingMode(editable ? FieldEditingMode.EDITABLE : FieldEditingMode.READONLY);
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public FormField<ENTITY, VALUE> setRequired(boolean required) {
        this.required = required;
        this.field.setRequired(required);
        return this;
    }

    public boolean isCustomField() {
        return this.customField;
    }

    public FormField<ENTITY, VALUE> setCustomField(boolean customField) {
        this.customField = customField;
        return this;
    }

    public AbstractField<VALUE> getField() {
        return this.field;
    }

    public FormField<ENTITY, VALUE> setField(AbstractField<VALUE> field) {
        this.field = field;
        return this;
    }

    public ValueExtractor<ENTITY> getValueExtractor() {
        return this.valueExtractor;
    }

    public FormField<ENTITY, VALUE> setValueExtractor(ValueExtractor<ENTITY> valueExtractor) {
        this.valueExtractor = valueExtractor;
        return this;
    }

    public ValueInjector<ENTITY, VALUE> getValueInjector() {
        return this.valueInjector;
    }

    public FormField<ENTITY, VALUE> setValueInjector(ValueInjector<ENTITY, VALUE> valueInjector) {
        this.valueInjector = valueInjector;
        return this;
    }

    public ColumnIndex getIndex() {
        return this.index;
    }

    public static AbstractField createField(ColumnIndex columnIndex, String title) {
        TextField field = null;
        switch (columnIndex.getColumnType()) {
            case BOOLEAN: 
            case BITSET_BOOLEAN: {
                field = new CheckBox(title);
                break;
            }
            case SHORT: 
            case INT: 
            case LONG: {
                field = new NumberField(0);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                field = new NumberField(-1);
                break;
            }
            case TEXT: 
            case TRANSLATABLE_TEXT: {
                field = new TextField();
                break;
            }
            case FILE: {
                break;
            }
            case SINGLE_REFERENCE: {
                break;
            }
            case MULTI_REFERENCE: {
                break;
            }
            case TIMESTAMP: 
            case DATE_TIME: {
                field = new InstantDateTimeField();
                break;
            }
            case DATE: {
                field = new InstantDateField();
                break;
            }
            case TIME: {
                field = new InstantTimeField();
                break;
            }
            case LOCAL_DATE: {
                field = new LocalDateField();
                break;
            }
            case ENUM: {
                field = new NumberField(0);
                break;
            }
            case BINARY: {
                break;
            }
            case CURRENCY: {
                break;
            }
        }
        return field;
    }

    public static ValueExtractor createValueExtractor(ColumnIndex index) {
        switch (index.getColumnType()) {
            case BOOLEAN: {
                break;
            }
            case BITSET_BOOLEAN: {
                break;
            }
            case SHORT: {
                break;
            }
            case INT: {
                break;
            }
            case LONG: {
                break;
            }
            case FLOAT: {
                break;
            }
            case DOUBLE: {
                break;
            }
            case TEXT: {
                break;
            }
            case TRANSLATABLE_TEXT: {
                break;
            }
            case FILE: {
                break;
            }
            case SINGLE_REFERENCE: {
                break;
            }
            case MULTI_REFERENCE: {
                break;
            }
            case TIMESTAMP: {
                break;
            }
            case DATE: {
                break;
            }
            case TIME: {
                break;
            }
            case DATE_TIME: {
                break;
            }
            case LOCAL_DATE: {
                break;
            }
            case ENUM: {
                break;
            }
            case BINARY: {
                break;
            }
            case CURRENCY: {
                break;
            }
        }
        return null;
    }
}

