/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.grouping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.grouping.GroupingNodeType;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.session.SessionContext;

public class GroupingNode {
    private final ColumnIndex index;
    private final GroupingNode parentNode;
    private final List<GroupingNode> childNodes;
    private final String title;
    private final Icon icon;
    private final ColumnType columnType;
    private GroupingNodeType nodeType;

    public GroupingNode(ColumnIndex index, String title, Icon icon) {
        this.index = index;
        this.title = title;
        this.icon = icon;
        this.parentNode = null;
        this.columnType = index.getColumnType();
        this.childNodes = this.createChildNodes();
        if (this.childNodes == null) {
            this.nodeType = GroupingNodeType.BY_VALUE;
        }
    }

    public GroupingNode(GroupingNode parentNode, String title, GroupingNodeType nodeType) {
        this.parentNode = parentNode;
        this.title = title;
        this.nodeType = nodeType;
        this.icon = parentNode.getIcon();
        this.childNodes = null;
        this.index = parentNode.getIndex();
        this.columnType = this.index.getColumnType();
    }

    public ColumnIndex getIndex() {
        return this.index;
    }

    public GroupingNode getParentNode() {
        return this.parentNode;
    }

    public List<GroupingNode> getChildNodes() {
        return this.childNodes;
    }

    public String getTitle() {
        return this.title;
    }

    public ColumnType getColumnType() {
        return this.columnType;
    }

    public GroupingNodeType getNodeType() {
        return this.nodeType;
    }

    public Icon getIcon() {
        return this.icon;
    }

    private List<GroupingNode> createChildNodes() {
        ArrayList<GroupingNode> childNodes = new ArrayList<GroupingNode>();
        switch (this.columnType) {
            case BOOLEAN: 
            case BITSET_BOOLEAN: {
                break;
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                break;
            }
            case TEXT: {
                childNodes.add(new GroupingNode(this, SessionContext.current().getLocalized(TeamAppsDictionary.BY_FULL_VALUE.getKey(), new Object[0]), GroupingNodeType.BY_VALUE));
                childNodes.add(new GroupingNode(this, SessionContext.current().getLocalized(TeamAppsDictionary.BY_WORDS.getKey(), new Object[0]), GroupingNodeType.TEXT_TERM));
                return childNodes;
            }
            case TRANSLATABLE_TEXT: {
                break;
            }
            case SINGLE_REFERENCE: {
                break;
            }
            case MULTI_REFERENCE: {
                break;
            }
            case TIMESTAMP: 
            case DATE: 
            case DATE_TIME: 
            case LOCAL_DATE: {
                childNodes.add(new GroupingNode(this, SessionContext.current().getLocalized(TeamAppsDictionary.BY_YEAR.getKey(), new Object[0]), GroupingNodeType.DATE_YEAR));
                childNodes.add(new GroupingNode(this, SessionContext.current().getLocalized(TeamAppsDictionary.BY_QUARTER.getKey(), new Object[0]), GroupingNodeType.DATE_QUARTER));
                childNodes.add(new GroupingNode(this, SessionContext.current().getLocalized(TeamAppsDictionary.BY_MONTH.getKey(), new Object[0]), GroupingNodeType.DATE_MONTH));
                childNodes.add(new GroupingNode(this, SessionContext.current().getLocalized(TeamAppsDictionary.BY_WEEK.getKey(), new Object[0]), GroupingNodeType.DATE_WEEK));
                childNodes.add(new GroupingNode(this, SessionContext.current().getLocalized(TeamAppsDictionary.BY_Day.getKey(), new Object[0]), GroupingNodeType.DATE_DAY));
                return childNodes;
            }
        }
        return Collections.emptyList();
    }
}

