/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.teamapps.data.value.SortDirection;
import org.teamapps.data.value.Sorting;
import org.teamapps.databinding.ObservableValue;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.FieldInfo;
import org.teamapps.udb.HeaderFieldBuilder;
import org.teamapps.udb.InfiniteItemViewBuilder;
import org.teamapps.udb.InfiniteItemViewModelBuilder;
import org.teamapps.udb.Map;
import org.teamapps.udb.MapModel;
import org.teamapps.udb.TableBuilder;
import org.teamapps.udb.TableModelBuilder;
import org.teamapps.udb.TimeGraphBuilder;
import org.teamapps.udb.TimeGraphModelBuilder;
import org.teamapps.udb.filter.TimeIntervalFilter;
import org.teamapps.udb.form.FormBuilder;
import org.teamapps.udb.grouping.GroupingView;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.pojo.AbstractUdbQuery;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.pojo.Query;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.session.SessionContext;

public class ModelBuilderFactory<ENTITY extends Entity<ENTITY>> {
    public final Event<TimeIntervalFilter> onTimeIntervalFilterChanged = new Event();
    public final Event<Filter> onGeoFilterChanged = new Event();
    public final Event<Filter> onGroupFilterChanged = new Event();
    public final Event<String> onFullTextQueryFilterChanged = new Event();
    public final Event<Void> onBaseQueryDataChanged = new Event();
    public final Event<Void> onTimeDataChanged = new Event();
    public final Event<Void> onGeoDataChanged = new Event();
    public final Event<Void> onGroupingDataChanged = new Event();
    public final Event<Void> onFinalDataChanged = new Event();
    public final Event<ENTITY> onRecordSelected = new Event();
    private ENTITY selectedRecord;
    private final TableIndex tableIndex;
    private final EntityBuilder<ENTITY> entityBuilder;
    private final TwoWayBindableValue<Integer> recordCount = TwoWayBindableValue.create();
    private Supplier<Query<ENTITY>> querySupplier;
    private AbstractUdbQuery<ENTITY> baseQuery;
    private AbstractUdbQuery<ENTITY> timeQuery;
    private AbstractUdbQuery<ENTITY> geoQuery;
    private AbstractUdbQuery<ENTITY> groupingQuery;
    private AbstractUdbQuery<ENTITY> finalQuery;
    private TimeIntervalFilter timeIntervalFilter;
    private Filter geoFilter;
    private Filter groupFilter;
    private String fullTextQuery;
    private List<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
    private NumberFormat numberFormat = NumberFormat.getInstance(SessionContext.current().getLocale());

    public ModelBuilderFactory(Supplier<Query<ENTITY>> querySupplier) {
        AbstractUdbQuery udbQuery = (AbstractUdbQuery)querySupplier.get();
        this.tableIndex = udbQuery.getTableIndex();
        this.entityBuilder = udbQuery.getEntityBuilder();
        this.setBaseQuery(querySupplier);
        this.onTimeIntervalFilterChanged.addListener(this::updateTimeFilterQuery);
        this.onGeoFilterChanged.addListener(this::updateGeoFilterQuery);
        this.onGroupFilterChanged.addListener(this::updateGroupingFilterQuery);
        this.onFullTextQueryFilterChanged.addListener(this::updateAllFiltersAppliedQuery);
        this.onRecordSelected.addListener(record -> {
            this.selectedRecord = record;
        });
    }

    public void setBaseQuery(Supplier<Query<ENTITY>> querySupplier) {
        this.querySupplier = querySupplier;
        this.baseQuery = (AbstractUdbQuery)querySupplier.get();
        this.updateTimeFilterQuery(this.timeIntervalFilter);
        this.onBaseQueryDataChanged.fire();
    }

    public void addFieldInfo(String name, String title, Icon icon) {
        this.addFieldInfo(new FieldInfo(name, title, icon));
    }

    public void addFieldInfo(FieldInfo fieldInfo) {
        this.fieldInfos.add(fieldInfo);
    }

    public List<FieldInfo> getFieldInfos() {
        return this.fieldInfos;
    }

    public ENTITY getSelectedRecord() {
        return this.selectedRecord;
    }

    private void updateTimeFilterQuery(TimeIntervalFilter timeIntervalFilter) {
        this.timeIntervalFilter = timeIntervalFilter;
        AbstractUdbQuery<ENTITY> query = this.createTimeIntervalQuery();
        this.timeQuery = query;
        this.updateGeoFilterQuery(this.geoFilter);
        this.onTimeDataChanged.fire();
    }

    private void updateGeoFilterQuery(Filter geoFilter) {
        this.geoFilter = geoFilter;
        AbstractUdbQuery<ENTITY> query = this.createGeoFiltersQuery();
        this.geoQuery = query;
        this.updateGroupingFilterQuery(this.groupFilter);
        this.onGeoDataChanged.fire();
    }

    private void updateGroupingFilterQuery(Filter filter) {
        this.groupFilter = filter;
        AbstractUdbQuery<ENTITY> query = this.createGroupingFiltersQuery();
        this.groupingQuery = query;
        this.updateAllFiltersAppliedQuery(this.fullTextQuery);
        this.onGroupingDataChanged.fire();
    }

    private void updateAllFiltersAppliedQuery(String fullTextQuery) {
        this.fullTextQuery = fullTextQuery;
        AbstractUdbQuery<ENTITY> query = this.createGroupingFiltersQuery();
        if (fullTextQuery != null && !fullTextQuery.isBlank()) {
            query.addFullTextQuery(fullTextQuery, new String[0]);
        }
        this.finalQuery = query;
        this.recordCount.set((Object)this.finalQuery.executeToBitSet().cardinality());
        this.onFinalDataChanged.fire();
    }

    private AbstractUdbQuery<ENTITY> createTimeIntervalQuery() {
        AbstractUdbQuery query = (AbstractUdbQuery)this.querySupplier.get();
        if (this.timeIntervalFilter != null) {
            NumericFilter numericFilter = this.tableIndex.getColumnIndex(this.timeIntervalFilter.getFieldName()).getType() == IndexType.INT ? this.timeIntervalFilter.getIntFilter() : this.timeIntervalFilter.getFilter();
            query.addNumericFilter(this.timeIntervalFilter.getFieldName(), numericFilter);
        }
        return query;
    }

    private AbstractUdbQuery<ENTITY> createGeoFiltersQuery() {
        AbstractUdbQuery<ENTITY> query = this.createTimeIntervalQuery();
        if (this.geoFilter != null) {
            query.and(this.geoFilter);
        }
        return query;
    }

    private AbstractUdbQuery<ENTITY> createGroupingFiltersQuery() {
        AbstractUdbQuery<ENTITY> query = this.createGeoFiltersQuery();
        if (this.groupFilter != null) {
            query.and(this.groupFilter);
        }
        return query;
    }

    public ObservableValue<Integer> getRecordCount() {
        return this.recordCount;
    }

    public HeaderFieldBuilder<ENTITY> createHeaderFieldBuilder() {
        return new HeaderFieldBuilder(this);
    }

    public TableModelBuilder<ENTITY> createTableModelBuilder() {
        return new TableModelBuilder(this);
    }

    public TableBuilder<ENTITY> createTableBuilder() {
        return new TableBuilder(this);
    }

    public InfiniteItemViewModelBuilder<ENTITY> createInfiniteItemViewModelBuilder() {
        return new InfiniteItemViewModelBuilder(this);
    }

    public InfiniteItemViewBuilder<ENTITY> createInfiniteItemViewBuilder() {
        return new InfiniteItemViewBuilder(this);
    }

    public TimeGraphModelBuilder<ENTITY> createTimeGraphModelBuilder() {
        return new TimeGraphModelBuilder(this);
    }

    public TimeGraphBuilder<ENTITY> createTimeGraphBuilder() {
        return new TimeGraphBuilder(this);
    }

    public MapModel<ENTITY> createMapModel() {
        return new MapModel(this);
    }

    public Map<ENTITY> createMap() {
        return new Map(this);
    }

    public GroupingView<ENTITY> createGroupingView(String ... fieldNames) {
        return new GroupingView(this, fieldNames);
    }

    public FormBuilder<ENTITY> createFormBuilder(EntityBuilder<ENTITY> entityBuilder) {
        return new FormBuilder<ENTITY>(this, entityBuilder);
    }

    public AbstractUdbQuery<ENTITY> getBaseQuery() {
        return this.baseQuery;
    }

    public AbstractUdbQuery<ENTITY> getTimeQuery() {
        return this.timeQuery;
    }

    public AbstractUdbQuery<ENTITY> getGeoQuery() {
        return this.geoQuery;
    }

    public AbstractUdbQuery<ENTITY> getGroupingQuery() {
        return this.groupingQuery;
    }

    public AbstractUdbQuery<ENTITY> getFinalQuery() {
        return this.finalQuery;
    }

    public Filter getGeoFilter() {
        return this.geoFilter;
    }

    public Filter getGroupFilter() {
        return this.groupFilter;
    }

    public TimeIntervalFilter getTimeIntervalFilter() {
        return this.timeIntervalFilter;
    }

    public String getFullTextQuery() {
        return this.fullTextQuery;
    }

    public TableIndex getTableIndex() {
        return this.tableIndex;
    }

    public EntityBuilder<ENTITY> getEntityBuilder() {
        return this.entityBuilder;
    }

    public String getCountAsString(long count) {
        return this.numberFormat.format(count);
    }

    protected org.teamapps.universaldb.query.Sorting convertSorting(Sorting sorting) {
        if (sorting == null || sorting.getFieldName() == null || sorting.getFieldName().isEmpty()) {
            return null;
        }
        return sorting.getSorting() == SortDirection.ASC ? new org.teamapps.universaldb.query.Sorting(sorting.getFieldName(), true) : new org.teamapps.universaldb.query.Sorting(sorting.getFieldName(), false);
    }
}

