/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.partitioning.StaticPartitioningTimeGraphModel;
import org.teamapps.ux.session.SessionContext;

public class TimeGraphModelBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    protected TimeGraphModelBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
    }

    private void updateBaseData(StaticPartitioningTimeGraphModel timeGraphModel, String fieldName) {
        BitSet recordSet = this.getModelBuilderFactory().getBaseQuery().executeToBitSet();
        long[] timestamps = this.queryTimestamps(recordSet, fieldName);
        timeGraphModel.setEventTimestampsForDataSeriesId("baseData", timestamps);
    }

    private void updateGeoFilterData(StaticPartitioningTimeGraphModel timeGraphModel, String fieldName) {
        if (this.getModelBuilderFactory().getGeoFilter() != null) {
            BitSet recordSet = this.getModelBuilderFactory().getGeoQuery().executeToBitSet();
            long[] timestamps = this.queryTimestamps(recordSet, fieldName);
            timeGraphModel.setEventTimestampsForDataSeriesId("geoData", timestamps);
        }
    }

    private void updateGroupFilterData(StaticPartitioningTimeGraphModel timeGraphModel, String fieldName) {
        if (this.getModelBuilderFactory().getGroupFilter() != null) {
            BitSet recordSet = this.getModelBuilderFactory().getGroupingQuery().executeToBitSet();
            long[] timestamps = this.queryTimestamps(recordSet, fieldName);
            timeGraphModel.setEventTimestampsForDataSeriesId("groupData", timestamps);
        }
    }

    private void updateFullTextFilterData(StaticPartitioningTimeGraphModel timeGraphModel, String fieldName) {
        if (this.getModelBuilderFactory().getFullTextQuery() != null && !this.getModelBuilderFactory().getFullTextQuery().isBlank()) {
            BitSet recordSet = this.getModelBuilderFactory().getFinalQuery().executeToBitSet();
            long[] timestamps = this.queryTimestamps(recordSet, fieldName);
            timeGraphModel.setEventTimestampsForDataSeriesId("fullTextData", timestamps);
        }
    }

    private long[] queryTimestamps(BitSet recordSet, String fieldName) {
        ColumnIndex columnIndex = this.getModelBuilderFactory().getTableIndex().getColumnIndex(fieldName);
        IntegerIndex integerIndex = null;
        LongIndex longIndex = null;
        if (columnIndex.getType() == IndexType.INT) {
            integerIndex = (IntegerIndex)columnIndex;
        } else {
            longIndex = (LongIndex)columnIndex;
        }
        ArrayList<Long> values = new ArrayList<Long>();
        int id = recordSet.nextSetBit(0);
        while (id >= 0) {
            long value2;
            long l = value2 = integerIndex != null ? (long)integerIndex.getValue(id) * 1000L : longIndex.getValue(id);
            if (value2 != 0L) {
                values.add(value2);
            }
            id = recordSet.nextSetBit(id + 1);
        }
        return values.stream().mapToLong(value -> value).toArray();
    }

    public TimeGraphModel build(String fieldName) {
        StaticPartitioningTimeGraphModel timeGraphModel = StaticPartitioningTimeGraphModel.create((ZoneId)SessionContext.current().getTimeZone());
        this.getModelBuilderFactory().onBaseQueryDataChanged.addListener(() -> this.updateBaseData(timeGraphModel, fieldName));
        this.getModelBuilderFactory().onGeoDataChanged.addListener(() -> this.updateGeoFilterData(timeGraphModel, fieldName));
        this.getModelBuilderFactory().onGroupingDataChanged.addListener(() -> this.updateGroupFilterData(timeGraphModel, fieldName));
        this.getModelBuilderFactory().onFinalDataChanged.addListener(() -> this.updateFullTextFilterData(timeGraphModel, fieldName));
        this.updateBaseData(timeGraphModel, fieldName);
        this.updateGroupFilterData(timeGraphModel, fieldName);
        this.updateFullTextFilterData(timeGraphModel, fieldName);
        return timeGraphModel;
    }
}

