/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.explorer;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.HashedMap;
import org.teamapps.icon.material.MaterialIcon;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.explorer.Node;
import org.teamapps.udb.explorer.NodeType;
import org.teamapps.udb.explorer.Util;
import org.teamapps.udb.form.FormBuilder;
import org.teamapps.udb.grouping.GroupingView;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.SchemaIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.AbstractUdbQuery;
import org.teamapps.ux.application.ResponsiveApplication;
import org.teamapps.ux.application.perspective.Perspective;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.charting.forcelayout.ExpandedState;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutGraph;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutLink;
import org.teamapps.ux.component.charting.forcelayout.ForceLayoutNode;
import org.teamapps.ux.component.charting.tree.TreeGraph;
import org.teamapps.ux.component.charting.tree.TreeGraphNode;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;
import org.teamapps.ux.session.SessionContext;

public class DatabaseExplorerApp {
    private final UniversalDB universalDB;
    private final ResponsiveApplication application;
    private final SchemaIndex schemaIndex;
    private Perspective forceLayoutPerspective;
    private Perspective treeGraphPerspective;
    private Map<Node, Perspective> perspectiveByNode = new HashedMap();

    public DatabaseExplorerApp(UniversalDB universalDB) {
        this.universalDB = universalDB;
        this.application = ResponsiveApplication.createApplication();
        this.schemaIndex = universalDB.getSchemaIndex();
        this.createUI();
    }

    public ResponsiveApplication getApplication() {
        return this.application;
    }

    private void createUI() {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node schemaNode = new Node("Schema", NodeType.SCHEMA, this.schemaIndex);
        nodes.add(schemaNode);
        for (DatabaseIndex database : this.schemaIndex.getDatabases()) {
            Node dbNode = new Node(database.getName(), NodeType.DATABASE, database, schemaNode);
            nodes.add(dbNode);
            for (TableIndex table : database.getTables()) {
                Node tableNode = new Node(table.getName(), NodeType.TABLE, table, dbNode);
                nodes.add(tableNode);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    Node columnNode = new Node(columnIndex.getName(), NodeType.COLUMN, columnIndex, tableNode);
                    nodes.add(columnNode);
                }
            }
        }
        View applicationView = View.createView((String)"left", (Icon)MaterialIcon.VIEW_CAROUSEL, (String)"Database", null);
        this.application.addApplicationView(applicationView);
        this.forceLayoutPerspective = this.application.addPerspective(Perspective.createPerspective());
        this.forceLayoutPerspective.addView(View.createView((String)"center", (Icon)MaterialIcon.VIEW_CAROUSEL, (String)"Entities", this.createForceLayoutGraph(this.schemaIndex)));
        this.treeGraphPerspective = this.application.addPerspective(Perspective.createPerspective());
        this.treeGraphPerspective.addView(View.createView((String)"center", (Icon)MaterialIcon.VIEW_CAROUSEL, (String)"Database", (Component)this.createTreeGraph(this.schemaIndex)));
        this.application.showPerspective(this.forceLayoutPerspective);
        NumberFormat numberFormat = NumberFormat.getInstance(SessionContext.current().getLocale());
        Tree tree = new Tree((TreeModel)new ListTreeModel(nodes));
        tree.setPropertyExtractor(Node.createPropertyExtractor(numberFormat));
        tree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_TWO_LINES);
        tree.setShowExpanders(true);
        tree.setPropertyExtractor(Node.createPropertyExtractor(numberFormat));
        tree.setTreeNodeInfoExtractor(node -> new TreeNodeInfo((Node)node){
            final /* synthetic */ Node val$node;
            {
                this.val$node = node;
            }

            public Object getParent() {
                return this.val$node.getParent();
            }

            public boolean isLazyChildren() {
                return false;
            }

            public boolean isExpanded() {
                return this.val$node.getType() == NodeType.SCHEMA || this.val$node.getType() == NodeType.DATABASE;
            }
        });
        ToolbarButtonGroup group = this.application.addApplicationButtonGroup(new ToolbarButtonGroup());
        group.addButton((ToolbarButton)ToolbarButton.create((Icon)MaterialIcon.CHROME_READER_MODE, (String)"Schema overview", (String)"Display overview of schema")).onClick.addListener(this::showTreeGraph);
        group.addButton((ToolbarButton)ToolbarButton.create((Icon)MaterialIcon.BLUR_CIRCULAR, (String)"Entity view", (String)"Display entities of schema")).onClick.addListener(this::showForceLayoutGraph);
        tree.onNodeSelected.addListener(this::handleNodeSelection);
        applicationView.setComponent((Component)tree);
    }

    private void handleNodeSelection(Node node) {
        switch (node.getType()) {
            case SCHEMA: {
                this.showTreeGraph();
                break;
            }
            case DATABASE: {
                this.showForceLayoutGraph();
                break;
            }
            case TABLE: {
                this.createTableViewer(node);
                break;
            }
        }
    }

    private void showTreeGraph() {
        this.application.showPerspective(this.treeGraphPerspective);
    }

    private void showForceLayoutGraph() {
        this.application.showPerspective(this.forceLayoutPerspective);
    }

    private void createTableViewer(Node node) {
        TableIndex tableIndex = node.getTableIndex();
        Perspective perspective = this.perspectiveByNode.get(node);
        if (perspective != null) {
            this.application.showPerspective(perspective);
            return;
        }
        perspective = this.application.addPerspective(Perspective.createPerspective());
        this.perspectiveByNode.put(node, perspective);
        View leftBottomView = perspective.addView(View.createView((String)"left-bottom", (Icon)MaterialIcon.VIEW_CAROUSEL, (String)"Grouping", null));
        View topView = perspective.addView(View.createView((String)"top", (Icon)MaterialIcon.VIEW_CAROUSEL, (String)node.getName(), null));
        View centerView = perspective.addView(View.createView((String)"center", (Icon)MaterialIcon.VIEW_CAROUSEL, (String)node.getName(), null));
        View rightView = perspective.addView(View.createView((String)"center-bottom", (Icon)MaterialIcon.VIEW_CAROUSEL, (String)node.getName(), null));
        String pojoNamespace = tableIndex.getDatabaseIndex().getSchemaIndex().getSchema().getPojoNamespace();
        String path = pojoNamespace + "." + tableIndex.getDatabaseIndex().getName() + ".Udb" + Util.getFirstUpper(tableIndex.getName());
        ModelBuilderFactory factory = new ModelBuilderFactory(() -> this.createQuery(path));
        for (ColumnIndex columnIndex : tableIndex.getColumnIndices()) {
            factory.addFieldInfo(columnIndex.getName(), Util.createTitleFromCamelCase(columnIndex.getName()), (Icon)MaterialIcon.LABEL_OUTLINE);
        }
        String[] fieldNames = tableIndex.getColumnIndices().stream().map(column -> column.getName()).collect(Collectors.toList()).toArray(new String[0]);
        factory.createTableBuilder().createAndAttachToViewWithHeaderField(centerView, node.getName(), fieldNames);
        FormBuilder formBuilder = factory.createFormBuilder(this.createEntity(path));
        formBuilder.addFields(fieldNames);
        formBuilder.createAndAttachToViewWithToolbarButtons(rightView);
        rightView.setVisible(true);
        TimeGraph timeGraph = factory.createTimeGraphBuilder().build();
        topView.setComponent((Component)timeGraph);
        topView.setVisible(true);
        GroupingView groupingView = factory.createGroupingView(fieldNames);
        groupingView.createAndAttachToViewWithHeaderField(leftBottomView);
        leftBottomView.setVisible(true);
        this.application.showPerspective(perspective);
    }

    private AbstractUdbQuery createQuery(String path) {
        try {
            return (AbstractUdbQuery)Class.forName(path + "Query").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private AbstractUdbEntity createEntity(String path) {
        try {
            return (AbstractUdbEntity)Class.forName(path).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ForceLayoutGraph<Node> createForceLayoutGraph(SchemaIndex schemaIndex) {
        ForceLayoutGraph graph = new ForceLayoutGraph();
        HashedMap graphNodeById = new HashedMap();
        NumberFormat numberFormat = NumberFormat.getInstance(SessionContext.current().getLocale());
        graph.setPropertyExtractor(Node.createPropertyExtractor(numberFormat));
        ArrayList<ForceLayoutNode<Node>> nodes = new ArrayList<ForceLayoutNode<Node>>();
        ArrayList<ForceLayoutLink> links = new ArrayList<ForceLayoutLink>();
        Node schemaNode = new Node("Schema", NodeType.SCHEMA, schemaIndex);
        ForceLayoutNode<Node> schemaGraphNode = this.createForceLayoutNode(schemaNode);
        nodes.add(schemaGraphNode);
        for (DatabaseIndex database : schemaIndex.getDatabases()) {
            Node dbNode = new Node(database.getName(), NodeType.DATABASE, database, schemaNode);
            ForceLayoutNode<Node> dbGraphNode = this.createForceLayoutNode(dbNode);
            nodes.add(dbGraphNode);
            links.add(new ForceLayoutLink(schemaGraphNode, dbGraphNode));
            for (TableIndex table2 : database.getTables()) {
                Node tableNode = new Node(table2.getName(), NodeType.TABLE, table2, dbNode);
                ForceLayoutNode<Node> tableGraphNode = this.createForceLayoutNode(tableNode);
                nodes.add(tableGraphNode);
                links.add(new ForceLayoutLink(dbGraphNode, tableGraphNode));
                graphNodeById.put(tableNode.getTableIndex().getFQN(), tableGraphNode);
                for (ColumnIndex columnIndex : table2.getColumnIndices()) {
                    Node columnNode = new Node(columnIndex.getName(), NodeType.COLUMN, columnIndex, tableNode);
                    ForceLayoutNode<Node> columnGraphNode = this.createForceLayoutNode(columnNode);
                    nodes.add(columnGraphNode);
                    links.add(new ForceLayoutLink(tableGraphNode, columnGraphNode));
                    graphNodeById.put(columnNode.getColumnIndex().getFQN(), columnGraphNode);
                }
            }
        }
        schemaIndex.getDatabases().stream().flatMap(db -> db.getTables().stream()).flatMap(table -> table.getColumnIndices().stream()).filter(column -> column.getColumnType().isReference()).forEach(arg_0 -> DatabaseExplorerApp.lambda$createForceLayoutGraph$6((Map)graphNodeById, links, arg_0));
        graph.addNodesAndLinks(nodes, links);
        graph.onNodeClicked.addListener(graphNode -> {
            Node node = (Node)graphNode.getRecord();
            this.handleNodeSelection(node);
        });
        return graph;
    }

    private ForceLayoutNode<Node> createForceLayoutNode(Node node) {
        ForceLayoutNode graphNode = new ForceLayoutNode((Object)node, 250, 60);
        graphNode.setTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        if (node.getType() == NodeType.COLUMN && !node.hasReferences()) {
            graphNode.setExpandedState(ExpandedState.NOT_EXPANDABLE);
        } else {
            graphNode.setExpandedState(ExpandedState.EXPANDED);
        }
        graphNode.setBorderColor(node.getColor());
        graphNode.setBackgroundColor(node.getBackgroundColor());
        graphNode.setBorderWidth(1.0f);
        graphNode.setBorderRadius(7.0f);
        if (node.getType() == NodeType.COLUMN) {
            graphNode.setWidth(170);
            graphNode.setHeight(36);
        }
        return graphNode;
    }

    private void createLink(ForceLayoutNode<Node> source, ForceLayoutNode<Node> target, List<ForceLayoutLink> links) {
        links.add(new ForceLayoutLink(source, target));
    }

    private Component createTreeGraph(SchemaIndex schemaIndex) {
        TreeGraph graph = new TreeGraph();
        graph.setCompact(true);
        NumberFormat numberFormat = NumberFormat.getInstance(SessionContext.current().getLocale());
        graph.setPropertyExtractor(Node.createPropertyExtractor(numberFormat));
        ArrayList<TreeGraphNode<Node>> nodes = new ArrayList<TreeGraphNode<Node>>();
        Node schemaNode = new Node("Schema", NodeType.SCHEMA, schemaIndex);
        TreeGraphNode<Node> schemaParent = this.createNode(schemaNode, null);
        nodes.add(schemaParent);
        for (DatabaseIndex database : schemaIndex.getDatabases()) {
            Node dbNode = new Node(database.getName(), NodeType.DATABASE, database);
            TreeGraphNode<Node> dbParent = this.createNode(dbNode, schemaParent);
            nodes.add(dbParent);
            for (TableIndex table : database.getTables()) {
                Node tableNode = new Node(table.getName(), NodeType.TABLE, table);
                TreeGraphNode<Node> tableParent = this.createNode(tableNode, dbParent);
                nodes.add(tableParent);
                ArrayList<TreeGraphNode<Node>> sideList = new ArrayList<TreeGraphNode<Node>>();
                tableParent.setSideListNodes(sideList);
                for (ColumnIndex columnIndex : table.getColumnIndices()) {
                    Node columnNode = new Node(columnIndex.getName(), NodeType.COLUMN, columnIndex);
                    TreeGraphNode<Node> columnGraphNode = this.createNode(columnNode, null);
                    sideList.add(columnGraphNode);
                }
            }
        }
        graph.setNodes(nodes);
        graph.onNodeClicked.addListener(graphNode -> {
            Node node = (Node)graphNode.getRecord();
            this.handleNodeSelection(node);
        });
        return graph;
    }

    private TreeGraphNode<Node> createNode(Node node, TreeGraphNode<Node> parent) {
        TreeGraphNode graphNode = new TreeGraphNode();
        graphNode.setTemplate((Template)BaseTemplate.LIST_ITEM_LARGE_ICON_TWO_LINES);
        if (node.getType() == NodeType.COLUMN) {
            graphNode.setHeight(36);
            graphNode.setWidth(170);
        } else {
            graphNode.setHeight(60);
            graphNode.setWidth(250);
        }
        graphNode.setBackgroundColor(node.getBackgroundColor());
        graphNode.setBorderColor(node.getColor());
        graphNode.setRecord((Object)node);
        graphNode.setParent(parent);
        return graphNode;
    }

    private static /* synthetic */ void lambda$createForceLayoutGraph$6(Map graphNodeById, List links, ColumnIndex column) {
        ColumnIndex referencedColumn;
        ForceLayoutNode node2;
        ForceLayoutNode node1;
        if (column.getColumnType().isReference()) {
            TableIndex referencedTable = null;
            if (column.getColumnType() == ColumnType.SINGLE_REFERENCE) {
                SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)column;
                referencedTable = singleReferenceIndex.getReferencedTable();
            } else {
                MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)column;
                referencedTable = multiReferenceIndex.getReferencedTable();
            }
            node1 = (ForceLayoutNode)graphNodeById.get(column.getFQN());
            node2 = (ForceLayoutNode)graphNodeById.get(referencedTable.getFQN());
            links.add(new ForceLayoutLink(node1, node2));
        }
        if ((referencedColumn = column.getReferencedColumn()) != null) {
            node1 = (ForceLayoutNode)graphNodeById.get(column.getFQN());
            node2 = (ForceLayoutNode)graphNodeById.get(referencedColumn.getFQN());
            links.add(new ForceLayoutLink(node1, node2));
        }
    }
}

