/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.form;

import java.time.Instant;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.FieldInfo;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.form.FormField;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.datetime.InstantDateField;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.datetime.InstantTimeField;
import org.teamapps.ux.component.field.datetime.LocalDateField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.form.ResponsiveFormSection;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.icon.TeamAppsIconBundle;
import org.teamapps.ux.session.SessionContext;

public class FormBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    private final EntityBuilder<ENTITY> entityBuilder;
    private ToolbarButton addRecordButton;
    private ToolbarButton saveButton;
    private ToolbarButton deleteButton;
    private ToolbarButton editButton;
    private ToolbarButton revertChangesButton;
    private ResponsiveForm<ENTITY> form;
    private ResponsiveFormLayout formLayout;
    private List<FormField<ENTITY, ? extends Object>> formFields = new ArrayList<FormField<ENTITY, ? extends Object>>();
    private Map<String, FormField<ENTITY, ? extends Object>> formFieldByName = new HashMap<String, FormField<ENTITY, ? extends Object>>();
    private final TwoWayBindableValue<ENTITY> displayedEntity = TwoWayBindableValue.create();

    public FormBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory, EntityBuilder<ENTITY> entityBuilder) {
        super(modelBuilderFactory);
        this.entityBuilder = entityBuilder;
        this.init();
    }

    private void init() {
        this.form = new ResponsiveForm(100, 150, 0);
        this.formLayout = this.form.addResponsiveFormLayout(450);
        ModelBuilderFactory factory = this.getModelBuilderFactory();
        factory.onRecordSelected.addListener(entity -> this.displayedEntity.set(entity));
        this.displayedEntity.onChanged().addListener(entity -> this.setFormValues(entity));
        this.addRecordButton = ToolbarButton.create((Icon)this.getIcon(TeamAppsIconBundle.ADD.getKey()), (String)this.getLocalized(TeamAppsDictionary.ADD.getKey(), new Object[0]), (String)this.getLocalized(TeamAppsDictionary.ADD_RECORD.getKey(), new Object[0]));
        this.saveButton = ToolbarButton.createSmall((Icon)this.getIcon(TeamAppsIconBundle.SAVE.getKey()), (String)this.getLocalized(TeamAppsDictionary.SAVE.getKey(), new Object[0]));
        this.deleteButton = ToolbarButton.createSmall((Icon)this.getIcon(TeamAppsIconBundle.DELETE.getKey()), (String)this.getLocalized(TeamAppsDictionary.DELETE.getKey(), new Object[0]));
        this.saveButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.displayedEntity.get();
            if (entity != null) {
                this.saveForm(entity);
            }
        });
        this.deleteButton.onClick.addListener(() -> {});
        this.addRecordButton.onClick.addListener(() -> this.setFormValues((Entity)this.entityBuilder.build()));
        this.displayedEntity.bindWritingTo(entity -> this.deleteButton.setVisible(entity != null));
        this.displayedEntity.bindWritingTo(entity -> this.saveButton.setVisible(entity != null));
    }

    public void createAndAttachToViewWithToolbarButtons(View view) {
        view.setComponent(this.form);
        ToolbarButtonGroup buttonGroup = view.addLocalButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton(this.saveButton);
        buttonGroup.addButton(this.deleteButton);
        buttonGroup = view.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton(this.addRecordButton);
    }

    public void setFormValues(ENTITY record) {
        AbstractUdbEntity entity = (AbstractUdbEntity)record;
        for (FormField<ENTITY, Object> formField : this.formFields) {
            if (formField.getIndex() != null) {
                ColumnIndex index = formField.getIndex();
                switch (index.getColumnType()) {
                    case BOOLEAN: 
                    case BITSET_BOOLEAN: {
                        CheckBox checkBox = (CheckBox)formField.getField();
                        checkBox.setValue((Object)entity.getBooleanValue((BooleanIndex)index));
                        break;
                    }
                    case SHORT: {
                        NumberField shortNumberField = (NumberField)formField.getField();
                        shortNumberField.setValue((Object)entity.getShortValue((ShortIndex)index));
                        break;
                    }
                    case INT: {
                        NumberField intNumberField = (NumberField)formField.getField();
                        intNumberField.setValue((Object)entity.getIntValue((IntegerIndex)index));
                        break;
                    }
                    case LONG: {
                        NumberField longNumberField = (NumberField)formField.getField();
                        longNumberField.setValue((Object)entity.getLongValue((LongIndex)index));
                        break;
                    }
                    case FLOAT: {
                        NumberField floatNumberField = (NumberField)formField.getField();
                        floatNumberField.setValue((Object)Float.valueOf(entity.getFloatValue((FloatIndex)index)));
                        break;
                    }
                    case DOUBLE: {
                        NumberField doubleNumberField = (NumberField)formField.getField();
                        doubleNumberField.setValue((Object)entity.getDoubleValue((DoubleIndex)index));
                        break;
                    }
                    case TEXT: {
                        TextField textField = (TextField)formField.getField();
                        textField.setValue((Object)entity.getTextValue((TextIndex)index));
                        break;
                    }
                    case TRANSLATABLE_TEXT: {
                        TextField translatableTextField = (TextField)formField.getField();
                        TranslatableText translatableTextValue = entity.getTranslatableTextValue((TranslatableTextIndex)index);
                        if (translatableTextValue == null) {
                            translatableTextField.setValue(null);
                            break;
                        }
                        translatableTextField.setValue((Object)translatableTextValue.getText(SessionContext.current().getLocale().getLanguage()));
                        break;
                    }
                    case FILE: {
                        break;
                    }
                    case SINGLE_REFERENCE: {
                        break;
                    }
                    case MULTI_REFERENCE: {
                        break;
                    }
                    case TIMESTAMP: {
                        InstantDateTimeField timestampField = (InstantDateTimeField)formField.getField();
                        timestampField.setValue((Object)entity.getTimestampValue((IntegerIndex)index));
                        break;
                    }
                    case DATE: {
                        InstantDateField dateField = (InstantDateField)formField.getField();
                        dateField.setValue((Object)entity.getDateValue((LongIndex)index));
                        break;
                    }
                    case TIME: {
                        InstantTimeField timeField = (InstantTimeField)formField.getField();
                        timeField.setValue((Object)entity.getTimeValue((IntegerIndex)index));
                        break;
                    }
                    case DATE_TIME: {
                        InstantDateTimeField dateTimeField = (InstantDateTimeField)formField.getField();
                        dateTimeField.setValue((Object)entity.getDateTimeValue((LongIndex)index));
                        break;
                    }
                    case LOCAL_DATE: {
                        LocalDateField localDateField = (LocalDateField)formField.getField();
                        localDateField.setValue((Object)entity.getLocalDateValue((LongIndex)index));
                        break;
                    }
                    case ENUM: {
                        break;
                    }
                    case BINARY: {
                        break;
                    }
                    case CURRENCY: {
                        break;
                    }
                }
                continue;
            }
            if (formField.getValueExtractor() == null) continue;
            ValueExtractor<ENTITY> valueExtractor = formField.getValueExtractor();
            Object value = valueExtractor.extract(record);
            AbstractField<? extends Object> field = formField.getField();
            field.setValue(value);
        }
    }

    public void saveForm(ENTITY record) {
        List fields = this.formFields.stream().map(f -> f.getField()).collect(Collectors.toList());
        if (!Fields.validateAll(fields)) {
            return;
        }
        AbstractUdbEntity entity = (AbstractUdbEntity)record;
        for (FormField<ENTITY, Object> formField : this.formFields) {
            if (!formField.isEditable()) continue;
            if (formField.getIndex() != null) {
                ColumnIndex index = formField.getIndex();
                switch (index.getColumnType()) {
                    case BOOLEAN: 
                    case BITSET_BOOLEAN: {
                        CheckBox checkBox = (CheckBox)formField.getField();
                        entity.setBooleanValue(((Boolean)checkBox.getValue()).booleanValue(), (BooleanIndex)index);
                        break;
                    }
                    case SHORT: {
                        NumberField shortNumberField = (NumberField)formField.getField();
                        entity.setShortValue(((Number)shortNumberField.getValue()).shortValue(), (ShortIndex)index);
                        break;
                    }
                    case INT: {
                        NumberField intNumberField = (NumberField)formField.getField();
                        entity.setIntValue(((Number)intNumberField.getValue()).intValue(), (IntegerIndex)index);
                        break;
                    }
                    case LONG: {
                        NumberField longNumberField = (NumberField)formField.getField();
                        entity.setLongValue(((Number)longNumberField.getValue()).longValue(), (LongIndex)index);
                        break;
                    }
                    case FLOAT: {
                        NumberField floatNumberField = (NumberField)formField.getField();
                        entity.setFloatValue(((Number)floatNumberField.getValue()).floatValue(), (FloatIndex)index);
                        break;
                    }
                    case DOUBLE: {
                        NumberField doubleNumberField = (NumberField)formField.getField();
                        entity.setDoubleValue(((Number)doubleNumberField.getValue()).doubleValue(), (DoubleIndex)index);
                        break;
                    }
                    case TEXT: {
                        TextField textField = (TextField)formField.getField();
                        entity.setTextValue((String)textField.getValue(), (TextIndex)index);
                        break;
                    }
                    case TRANSLATABLE_TEXT: {
                        TextField translatableTextField = (TextField)formField.getField();
                        String value = (String)translatableTextField.getValue();
                        if (value != null) {
                            entity.setTranslatableTextValue(new TranslatableText(value, SessionContext.current().getLocale().getLanguage()), (TranslatableTextIndex)index);
                            break;
                        }
                        entity.setTranslatableTextValue(null, (TranslatableTextIndex)index);
                        break;
                    }
                    case FILE: {
                        break;
                    }
                    case SINGLE_REFERENCE: {
                        break;
                    }
                    case MULTI_REFERENCE: {
                        break;
                    }
                    case TIMESTAMP: {
                        InstantDateTimeField timestampField = (InstantDateTimeField)formField.getField();
                        entity.setTimestampValue((Instant)timestampField.getValue(), (IntegerIndex)index);
                        break;
                    }
                    case DATE: {
                        InstantDateField dateField = (InstantDateField)formField.getField();
                        entity.setDateValue((Instant)dateField.getValue(), (LongIndex)index);
                        break;
                    }
                    case TIME: {
                        InstantTimeField timeField = (InstantTimeField)formField.getField();
                        entity.setTimeValue((Instant)timeField.getValue(), (IntegerIndex)index);
                        break;
                    }
                    case DATE_TIME: {
                        InstantDateTimeField dateTimeField = (InstantDateTimeField)formField.getField();
                        entity.setDateTimeValue((Instant)dateTimeField.getValue(), (LongIndex)index);
                        break;
                    }
                    case LOCAL_DATE: {
                        LocalDateField localDateField = (LocalDateField)formField.getField();
                        entity.setLocalDateValue((LocalDate)localDateField.getValue(), (LongIndex)index);
                        break;
                    }
                    case ENUM: {
                        break;
                    }
                    case BINARY: {
                        break;
                    }
                    case CURRENCY: {
                        break;
                    }
                }
                continue;
            }
            if (formField.getValueInjector() == null) continue;
            ValueInjector<ENTITY, ? extends Object> valueInjector = formField.getValueInjector();
            AbstractField<? extends Object> field = formField.getField();
            Object value = field.getValue();
            valueInjector.inject(record, value);
        }
        entity.save();
        SessionContext.current().showNotification(this.getIcon(TeamAppsIconBundle.SAVE.getKey()), this.getLocalized(TeamAppsDictionary.RECORD_SUCCESSFULLY_SAVED.getKey(), new Object[0]));
    }

    public ResponsiveFormSection addSection() {
        ResponsiveFormSection section = this.formLayout.addSection();
        section.setDrawHeaderLine(false);
        section.setCollapsible(false);
        return section;
    }

    public ResponsiveFormSection addSection(Icon icon, String text) {
        return this.formLayout.addSection(icon, text);
    }

    public void addFields(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.addField(fieldName);
        }
    }

    public <VALUE> FormField<ENTITY, VALUE> addField(String fieldName) {
        ColumnIndex index = this.getModelBuilderFactory().getTableIndex().getColumnIndex(fieldName);
        FormField formField = new FormField(fieldName, index);
        FieldInfo fieldInfo = this.getFieldInfo(fieldName);
        if (fieldInfo != null) {
            formField.setIcon(fieldInfo.getIcon());
            formField.setTitle(fieldInfo.getTitle());
        }
        if (index != null) {
            AbstractField abstractField = FormField.createField(index, formField.getTitle());
            formField.setField(abstractField);
        }
        this.addFormField(formField);
        return formField;
    }

    public FormField<ENTITY, String> addTextField(String fieldName) {
        return this.addField(fieldName);
    }

    public <VALUE> void addCustomField(FormField<ENTITY, VALUE> formField) {
        this.addFormField(formField);
    }

    private <VALUE> void addFormField(FormField<ENTITY, VALUE> formField) {
        if (formField.getField() == null) {
            return;
        }
        this.formFields.add(formField);
        this.formFieldByName.put(formField.getName(), formField);
        this.formLayout.addLabelAndField(formField.getIcon(), formField.getTitle(), formField.getName(), formField.getField());
    }

    private FieldInfo getFieldInfo(String fieldName) {
        return this.getModelBuilderFactory().getFieldInfos().stream().filter(fieldInfo -> fieldInfo.getName().equals(fieldName)).findAny().orElse(null);
    }
}

