/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.Field;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.session.SessionContext;

public abstract class AbstractBuilder<ENTITY extends Entity<ENTITY>> {
    private final ModelBuilderFactory<ENTITY> modelBuilderFactory;
    private List<Field<ENTITY, ? extends Object>> fields = new ArrayList<Field<ENTITY, ? extends Object>>();

    protected AbstractBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        this.modelBuilderFactory = modelBuilderFactory;
    }

    public ModelBuilderFactory<ENTITY> getModelBuilderFactory() {
        return this.modelBuilderFactory;
    }

    public String getLocalized(String key, Object ... parameters) {
        return SessionContext.current().getLocalized(key, parameters);
    }

    public Icon getIcon(String key) {
        return SessionContext.current().getIcon(key);
    }

    protected <VALUE> void handleNewField(Field<ENTITY, VALUE> field) {
    }

    public List<Field<ENTITY, ? extends Object>> getFields() {
        return this.fields;
    }

    public void addFieldCopies(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.addFieldCopy(fieldName);
        }
    }

    public Field<ENTITY, ?> addFieldCopy(String fieldName) {
        Field field = this.modelBuilderFactory.getFields().stream().filter(f -> f.getName().equals(fieldName)).findAny().orElseThrow();
        Field newField = field.copy();
        this.addField(newField);
        return newField;
    }

    public void addFields(Field<ENTITY, ?> ... fields) {
        for (Field<ENTITY, ?> field : fields) {
            this.addField(field);
        }
    }

    public void addFields(List<Field<ENTITY, ?>> fields) {
        fields.forEach(f -> this.addField((Field)f));
    }

    public <VALUE> Field<ENTITY, VALUE> addField(String fieldName, String title) {
        return this.addField(fieldName, title, null);
    }

    public <VALUE> Field<ENTITY, VALUE> addField(String fieldName, String title, Icon icon) {
        ColumnIndex index = this.getModelBuilderFactory().getTableIndex().getColumnIndex(fieldName);
        Field field = Field.createField(fieldName, title, icon, index);
        return this.addField(field);
    }

    public <VALUE> Field<ENTITY, VALUE> addField(Field<ENTITY, VALUE> field) {
        if (field.getField() == null) {
            return null;
        }
        this.fields.add(field);
        if (field.getField() != null) {
            this.handleNewField(field);
        }
        return field;
    }
}

