/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.event.Event;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.Field;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.TimeGraphModelBuilder;
import org.teamapps.udb.filter.TimeIntervalFilter;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.LineChartCurveType;
import org.teamapps.ux.component.timegraph.LineChartDataDisplayGroup;
import org.teamapps.ux.component.timegraph.LineChartLine;
import org.teamapps.ux.component.timegraph.LineChartYScaleZoomMode;
import org.teamapps.ux.component.timegraph.ScaleType;
import org.teamapps.ux.component.timegraph.TimeGraph;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.model.ComboBoxModel;
import org.teamapps.ux.model.ListTreeModel;

public class TimeGraphBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    public static final String BASE_DATA_SERIES = "baseData";
    public static final String GEO_FILTER_SERIES = "geoData";
    public static final String GROUP_FILTER_SERIES = "groupData";
    public static final String FULL_TEXT_DATA_SERIES = "fullTextData";
    public Event<String> onQueryFieldChanged = new Event();
    private ScaleType scaleType = ScaleType.LOG10;
    private LineChartLine baseLine;
    private LineChartLine groupingLine;
    private LineChartLine geoFilterLine;
    private LineChartLine fullTextFilterLine;

    protected TimeGraphBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
        this.setChartLines();
    }

    private void setChartLines() {
        this.baseLine = this.createChartLine(BASE_DATA_SERIES, Color.MATERIAL_BLUE_700);
        this.geoFilterLine = this.createChartLine(GEO_FILTER_SERIES, Color.MATERIAL_RED_700);
        this.groupingLine = this.createChartLine(GROUP_FILTER_SERIES, Color.MATERIAL_GREEN_800);
        this.fullTextFilterLine = this.createChartLine(FULL_TEXT_DATA_SERIES, Color.MATERIAL_AMBER_700);
    }

    public LineChartLine createChartLine(String lineName, Color color) {
        LineChartLine line = new LineChartLine(lineName, LineChartCurveType.MONOTONE, 0.5f, color, color.withAlpha(0.05f));
        line.setAreaColorScaleMin(color.withAlpha(0.05f));
        line.setAreaColorScaleMax(color.withAlpha(0.5f));
        line.setYScaleType(this.scaleType);
        line.setYScaleZoomMode(LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO);
        return line;
    }

    public TimeGraph build() {
        List fields = this.getFields();
        if (fields.isEmpty()) {
            fields = this.getModelBuilderFactory().getFields();
        }
        TimeGraphModelBuilder timeGraphModelBuilder = new TimeGraphModelBuilder(this.getModelBuilderFactory(), fields);
        TimeGraphModel timeGraphModel = timeGraphModelBuilder.build();
        TimeGraph timeGraph = new TimeGraph(timeGraphModel);
        this.updateLines(timeGraph);
        this.getModelBuilderFactory().onGroupingDataChanged.addListener(() -> this.updateLines(timeGraph));
        this.getModelBuilderFactory().onFinalDataChanged.addListener(() -> this.updateLines(timeGraph));
        timeGraph.onIntervalSelected.addListener(interval -> this.getModelBuilderFactory().onTimeIntervalFilterChanged.fire((Object)(interval == null ? null : new TimeIntervalFilter(timeGraphModelBuilder.getQueryFieldName(), interval.getMin(), interval.getMax()))));
        this.onQueryFieldChanged.addListener(fieldName -> timeGraphModelBuilder.setQueryFieldName((String)fieldName));
        return timeGraph;
    }

    public TimeGraph createAndAttachToViewWithHeaderField(View view) {
        List dateFields;
        TimeGraph timeGraph = this.build();
        view.setComponent((Component)timeGraph);
        List fields = this.getFields();
        if (fields.isEmpty()) {
            fields = this.getModelBuilderFactory().getFields();
        }
        if ((dateFields = fields.stream().filter(field -> TimeGraphModelBuilder.isDateField(field)).collect(Collectors.toList())).size() > 1) {
            ComboBox fieldSelectorComboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
            ListTreeModel comboBoxModel = new ListTreeModel(dateFields);
            fieldSelectorComboBox.setModel((ComboBoxModel)comboBoxModel);
            fieldSelectorComboBox.setValue((Object)((Field)dateFields.get(0)));
            fieldSelectorComboBox.setPropertyExtractor((field, propertyName) -> {
                switch (propertyName) {
                    case "icon": {
                        return field.getIcon();
                    }
                    case "caption": {
                        return field.getTitle();
                    }
                }
                return null;
            });
            fieldSelectorComboBox.onValueChanged.addListener(field -> this.onQueryFieldChanged.fire((Object)field.getName()));
            view.getPanel().setRightHeaderField((AbstractField)fieldSelectorComboBox);
        }
        return timeGraph;
    }

    private void updateLines(TimeGraph timeGraph) {
        LineChartDataDisplayGroup lineChartDataDisplayGroup = new LineChartDataDisplayGroup();
        lineChartDataDisplayGroup.setYScaleType(this.scaleType);
        lineChartDataDisplayGroup.setYZeroLineVisible(false);
        lineChartDataDisplayGroup.setYScaleZoomMode(LineChartYScaleZoomMode.DYNAMIC_INCLUDING_ZERO);
        lineChartDataDisplayGroup.setYAxisColor(Color.BLACK);
        ArrayList<LineChartLine> lines = new ArrayList<LineChartLine>();
        lines.add(this.baseLine);
        lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.baseLine);
        if (this.getModelBuilderFactory().getGeoFilter() != null) {
            lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.geoFilterLine);
            lines.add(this.geoFilterLine);
        }
        if (this.getModelBuilderFactory().getGroupFilter() != null) {
            lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.groupingLine);
            lines.add(this.groupingLine);
        }
        if (this.getModelBuilderFactory().getFullTextQuery() != null && !this.getModelBuilderFactory().getFullTextQuery().isBlank()) {
            lineChartDataDisplayGroup.addDataDisplay((AbstractLineChartDataDisplay)this.fullTextFilterLine);
            lines.add(this.fullTextFilterLine);
        }
        timeGraph.setLines(lines);
    }

    public TimeGraphBuilder<ENTITY> setScaleType(boolean logarithmic) {
        this.scaleType = logarithmic ? ScaleType.LOG10 : ScaleType.LINEAR;
        return this;
    }

    public LineChartLine getBaseLine() {
        return this.baseLine;
    }

    public TimeGraphBuilder<ENTITY> setBaseLine(LineChartLine baseLine) {
        this.baseLine = baseLine;
        return this;
    }

    public LineChartLine getGroupingLine() {
        return this.groupingLine;
    }

    public TimeGraphBuilder<ENTITY> setGroupingLine(LineChartLine groupingLine) {
        this.groupingLine = groupingLine;
        return this;
    }

    public LineChartLine getFullTextFilterLine() {
        return this.fullTextFilterLine;
    }

    public TimeGraphBuilder<ENTITY> setFullTextFilterLine(LineChartLine fullTextFilterLine) {
        this.fullTextFilterLine = fullTextFilterLine;
        return this;
    }
}

