/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.decider;

import org.teamapps.udb.decider.DeletionDecider;
import org.teamapps.udb.decider.EntityValidationResult;
import org.teamapps.udb.decider.ModificationDecider;
import org.teamapps.udb.decider.RestoreDecider;
import org.teamapps.udb.decider.ValidationDecider;

public class DeciderSet<ENTITY> {
    private final boolean allowCreation;
    private final boolean allowReadingDeleted;
    private final ModificationDecider<ENTITY> modificationDecider;
    private final DeletionDecider<ENTITY> deletionDecider;
    private final RestoreDecider<ENTITY> restoreDecider;
    private final ValidationDecider<ENTITY> validationDecider;

    public static <ENTITY> DeciderSet<ENTITY> create(boolean allowCreation, boolean allowModification, boolean allowDeletion, boolean allowReadingDeleted, boolean allowRestoreDeleted) {
        return new DeciderSet<Object>(allowCreation, entity -> allowModification, entity -> allowDeletion, allowReadingDeleted, entity -> allowRestoreDeleted, entity -> EntityValidationResult.createOK());
    }

    public static <ENTITY> DeciderSet<ENTITY> createReadOnly() {
        return DeciderSet.create(false, false, false, false, false);
    }

    public DeciderSet(boolean allowCreation, ModificationDecider<ENTITY> modificationDecider, DeletionDecider<ENTITY> deletionDecider, boolean allowReadingDeleted, RestoreDecider<ENTITY> restoreDecider, ValidationDecider<ENTITY> validationDecider) {
        this.allowCreation = allowCreation;
        this.allowReadingDeleted = allowReadingDeleted;
        this.modificationDecider = modificationDecider;
        this.deletionDecider = deletionDecider;
        this.restoreDecider = restoreDecider;
        this.validationDecider = validationDecider;
    }

    public boolean isAllowCreation() {
        return this.allowCreation;
    }

    public boolean isAllowReadingDeleted() {
        return this.allowReadingDeleted;
    }

    public ModificationDecider<ENTITY> getModificationDecider() {
        return this.modificationDecider;
    }

    public DeletionDecider<ENTITY> getDeletionDecider() {
        return this.deletionDecider;
    }

    public RestoreDecider<ENTITY> getRestoreDecider() {
        return this.restoreDecider;
    }

    public ValidationDecider<ENTITY> getValidationDecider() {
        return this.validationDecider;
    }
}

