/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.event.Event;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.Marker;

public class MapModel<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    public Event<Void> onAllDataChanged = new Event();
    private ColumnIndex latitudeIndex;
    private ColumnIndex longitudeIndex;
    private int markerOffsetX;
    private int markerOffsetY;

    protected MapModel(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
        this.getModelBuilderFactory().onTimeDataChanged.addListener(() -> this.onAllDataChanged.fire());
        this.setLocationFields("latitude", "longitude");
    }

    public List<Marker<ENTITY>> getMarkers() {
        ArrayList<Marker<ENTITY>> markers = new ArrayList<Marker<ENTITY>>();
        if (this.latitudeIndex == null || this.longitudeIndex == null) {
            return markers;
        }
        FloatIndex latFloat = null;
        FloatIndex lonFloat = null;
        DoubleIndex latDouble = null;
        DoubleIndex lonDouble = null;
        if (this.latitudeIndex.getColumnType() == ColumnType.FLOAT) {
            latFloat = (FloatIndex)this.latitudeIndex;
            lonFloat = (FloatIndex)this.longitudeIndex;
        } else {
            latDouble = (DoubleIndex)this.latitudeIndex;
            lonDouble = (DoubleIndex)this.longitudeIndex;
        }
        List entities = this.getModelBuilderFactory().getEntities(this.getModelBuilderFactory().getTimeBitSet());
        for (Entity entity : entities) {
            int id = entity.getId();
            Location location = null;
            location = latFloat != null ? new Location((double)latFloat.getValue(id), (double)lonFloat.getValue(id)) : new Location(latDouble.getValue(id), lonDouble.getValue(id));
            if (location.getLatitude() == 0.0) continue;
            markers.add(new Marker(location, null, (Object)entity, this.markerOffsetX, this.markerOffsetY));
        }
        return markers;
    }

    public void setLocationFields(String latitudeFieldName, String longitudeFieldName) {
        this.latitudeIndex = this.getModelBuilderFactory().getTableIndex().getColumnIndex(latitudeFieldName);
        this.longitudeIndex = this.getModelBuilderFactory().getTableIndex().getColumnIndex(longitudeFieldName);
    }

    public ColumnIndex getLatitudeIndex() {
        return this.latitudeIndex;
    }

    public ColumnIndex getLongitudeIndex() {
        return this.longitudeIndex;
    }

    public int getMarkerOffsetX() {
        return this.markerOffsetX;
    }

    public void setMarkerOffsetX(int markerOffsetX) {
        this.markerOffsetX = markerOffsetX;
    }

    public int getMarkerOffsetY() {
        return this.markerOffsetY;
    }

    public void setMarkerOffsetY(int markerOffsetY) {
        this.markerOffsetY = markerOffsetY;
    }
}

