/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.form;

import java.time.Instant;
import java.time.LocalDate;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.databinding.TwoWayBindableValue;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.Field;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.decider.DeciderSet;
import org.teamapps.udb.decider.EntityValidationResult;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.bool.BooleanIndex;
import org.teamapps.universaldb.index.numeric.DoubleIndex;
import org.teamapps.universaldb.index.numeric.FloatIndex;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.index.numeric.ShortIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.index.translation.TranslatableText;
import org.teamapps.universaldb.index.translation.TranslatableTextIndex;
import org.teamapps.universaldb.pojo.AbstractUdbEntity;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.record.EntityBuilder;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.dialogue.Dialogue;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.Fields;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.datetime.InstantDateField;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.datetime.InstantTimeField;
import org.teamapps.ux.component.field.datetime.LocalDateField;
import org.teamapps.ux.component.form.ResponsiveForm;
import org.teamapps.ux.component.form.ResponsiveFormLayout;
import org.teamapps.ux.component.form.ResponsiveFormSection;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.icon.TeamAppsIconBundle;
import org.teamapps.ux.session.SessionContext;

public class FormBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    private final EntityBuilder<ENTITY> entityBuilder;
    private final DeciderSet<ENTITY> deciderSet;
    private ToolbarButton addRecordButton;
    private ToolbarButton saveButton;
    private ToolbarButton deleteButton;
    private ToolbarButton editButton;
    private ToolbarButton revertChangesButton;
    private ResponsiveForm<ENTITY> form;
    private ResponsiveFormLayout formLayout;
    private final TwoWayBindableValue<ENTITY> displayedEntity = TwoWayBindableValue.create();
    private final BeanPropertyExtractor<ENTITY> beanPropertyExtractor;

    public FormBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory, EntityBuilder<ENTITY> entityBuilder, DeciderSet<ENTITY> deciderSet) {
        super(modelBuilderFactory);
        this.entityBuilder = entityBuilder;
        this.deciderSet = deciderSet;
        this.beanPropertyExtractor = new BeanPropertyExtractor();
        this.init();
    }

    private void init() {
        this.form = new ResponsiveForm(100, 150, 0);
        this.formLayout = this.form.addResponsiveFormLayout(450);
        ModelBuilderFactory factory = this.getModelBuilderFactory();
        this.addRecordButton = ToolbarButton.create((Icon)this.getIcon(TeamAppsIconBundle.ADD.getKey()), (String)this.getLocalized(TeamAppsDictionary.ADD.getKey(), new Object[0]), (String)this.getLocalized(TeamAppsDictionary.ADD_RECORD.getKey(), new Object[0]));
        this.saveButton = ToolbarButton.createSmall((Icon)this.getIcon(TeamAppsIconBundle.SAVE.getKey()), (String)this.getLocalized(TeamAppsDictionary.SAVE.getKey(), new Object[0]));
        this.deleteButton = ToolbarButton.createSmall((Icon)this.getIcon(TeamAppsIconBundle.DELETE.getKey()), (String)this.getLocalized(TeamAppsDictionary.DELETE.getKey(), new Object[0]));
        this.addRecordButton.setVisible(this.deciderSet.isAllowCreation());
        this.saveButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.displayedEntity.get();
            EntityValidationResult validationResult = this.deciderSet.getValidationDecider().validate(entity);
            if (validationResult.isSuccess()) {
                this.saveForm(entity);
            } else {
                Dialogue.showOk((Icon)this.getIcon(TeamAppsIconBundle.DELETE.getKey()), (String)validationResult.getError(), (String)validationResult.getError());
            }
        });
        this.deleteButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.displayedEntity.get();
            Dialogue okCancel = Dialogue.createOkCancel((Icon)this.getIcon(TeamAppsIconBundle.DELETE.getKey()), (String)this.getLocalized(TeamAppsDictionary.DELETE_RECORD.getKey(), new Object[0]));
            okCancel.show();
            okCancel.onResult.addListener(ok -> {
                if (ok.booleanValue()) {
                    entity.delete();
                }
            });
        });
        this.addRecordButton.onClick.addListener(() -> {
            Entity entity = (Entity)this.entityBuilder.build();
            this.displayedEntity.set((Object)entity);
        });
        factory.onRecordSelected.addListener(entity -> this.displayedEntity.set(entity));
        this.displayedEntity.onChanged().addListener(entity -> {
            this.setFormValues(entity);
            this.deleteButton.setVisible(this.deciderSet.getDeletionDecider().allowDeletion((Entity)entity));
            if (!entity.isStored()) {
                this.saveButton.setVisible(this.deciderSet.isAllowCreation());
            } else {
                this.saveButton.setVisible(this.deciderSet.getModificationDecider().allowModification((Entity)entity));
            }
        });
    }

    public void createAndAttachToViewWithToolbarButtons(View view) {
        if (this.getFields().isEmpty()) {
            this.addSection();
            for (Field field : this.getModelBuilderFactory().getFields()) {
                this.addFieldCopy(field.getName());
            }
        }
        view.setComponent(this.form);
        ToolbarButtonGroup buttonGroup = view.addLocalButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton(this.saveButton);
        buttonGroup.addButton(this.deleteButton);
        buttonGroup = view.addWorkspaceButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton(this.addRecordButton);
    }

    public void setFormValues(ENTITY record) {
        for (Field formField : this.getFields()) {
            if (formField.getIndex() != null && formField.getField() != null) {
                ColumnIndex index = formField.getIndex();
                if (index.getColumnType() == ColumnType.TRANSLATABLE_TEXT) {
                    AbstractUdbEntity entity = (AbstractUdbEntity)record;
                    TextField translatableTextField = (TextField)formField.getField();
                    TranslatableText translatableTextValue = entity.getTranslatableTextValue((TranslatableTextIndex)index);
                    if (translatableTextValue == null) {
                        translatableTextField.setValue(null);
                        continue;
                    }
                    translatableTextField.setValue((Object)translatableTextValue.getText(SessionContext.current().getLocale().getLanguage()));
                    continue;
                }
                AbstractField<Object> field = formField.getField();
                field.setValue(this.beanPropertyExtractor.getValue(record, index.getName()));
                continue;
            }
            if (formField.getValueExtractor() == null) continue;
            ValueExtractor valueExtractor = formField.getValueExtractor();
            Object value = valueExtractor.extract(record);
            AbstractField<Object> field = formField.getField();
            field.setValue(value);
        }
    }

    public void saveForm(ENTITY record) {
        List fields = this.getFields().stream().map(Field::getField).collect(Collectors.toList());
        if (!Fields.validateAll(fields)) {
            return;
        }
        AbstractUdbEntity entity = (AbstractUdbEntity)record;
        for (Field formField : this.getFields()) {
            if (!formField.isEditable()) continue;
            if (formField.getIndex() != null) {
                ColumnIndex index = formField.getIndex();
                switch (index.getColumnType()) {
                    case BOOLEAN: 
                    case BITSET_BOOLEAN: {
                        CheckBox checkBox = (CheckBox)formField.getField();
                        entity.setBooleanValue(((Boolean)checkBox.getValue()).booleanValue(), (BooleanIndex)index);
                        break;
                    }
                    case SHORT: {
                        NumberField shortNumberField = (NumberField)formField.getField();
                        entity.setShortValue(shortNumberField.getValue() != null ? ((Number)shortNumberField.getValue()).shortValue() : (short)0, (ShortIndex)index);
                        break;
                    }
                    case INT: {
                        NumberField intNumberField = (NumberField)formField.getField();
                        entity.setIntValue(intNumberField.getValue() != null ? ((Number)intNumberField.getValue()).intValue() : 0, (IntegerIndex)index);
                        break;
                    }
                    case LONG: {
                        NumberField longNumberField = (NumberField)formField.getField();
                        entity.setLongValue(longNumberField.getValue() != null ? ((Number)longNumberField.getValue()).longValue() : 0L, (LongIndex)index);
                        break;
                    }
                    case FLOAT: {
                        NumberField floatNumberField = (NumberField)formField.getField();
                        entity.setFloatValue(floatNumberField.getValue() != null ? ((Number)floatNumberField.getValue()).floatValue() : 0.0f, (FloatIndex)index);
                        break;
                    }
                    case DOUBLE: {
                        NumberField doubleNumberField = (NumberField)formField.getField();
                        entity.setDoubleValue(doubleNumberField.getValue() != null ? ((Number)doubleNumberField.getValue()).doubleValue() : 0.0, (DoubleIndex)index);
                        break;
                    }
                    case TEXT: {
                        TextField textField = (TextField)formField.getField();
                        entity.setTextValue((String)textField.getValue(), (TextIndex)index);
                        break;
                    }
                    case TRANSLATABLE_TEXT: {
                        TextField translatableTextField = (TextField)formField.getField();
                        String value = (String)translatableTextField.getValue();
                        if (value != null) {
                            entity.setTranslatableTextValue(new TranslatableText(value, SessionContext.current().getLocale().getLanguage()), (TranslatableTextIndex)index);
                            break;
                        }
                        entity.setTranslatableTextValue(null, (TranslatableTextIndex)index);
                        break;
                    }
                    case FILE: {
                        break;
                    }
                    case SINGLE_REFERENCE: {
                        break;
                    }
                    case MULTI_REFERENCE: {
                        break;
                    }
                    case TIMESTAMP: {
                        InstantDateTimeField timestampField = (InstantDateTimeField)formField.getField();
                        entity.setTimestampValue((Instant)timestampField.getValue(), (IntegerIndex)index);
                        break;
                    }
                    case DATE: {
                        InstantDateField dateField = (InstantDateField)formField.getField();
                        entity.setDateValue((Instant)dateField.getValue(), (LongIndex)index);
                        break;
                    }
                    case TIME: {
                        InstantTimeField timeField = (InstantTimeField)formField.getField();
                        entity.setTimeValue((Instant)timeField.getValue(), (IntegerIndex)index);
                        break;
                    }
                    case DATE_TIME: {
                        InstantDateTimeField dateTimeField = (InstantDateTimeField)formField.getField();
                        entity.setDateTimeValue((Instant)dateTimeField.getValue(), (LongIndex)index);
                        break;
                    }
                    case LOCAL_DATE: {
                        LocalDateField localDateField = (LocalDateField)formField.getField();
                        entity.setLocalDateValue((LocalDate)localDateField.getValue(), (LongIndex)index);
                        break;
                    }
                    case ENUM: {
                        break;
                    }
                    case BINARY: {
                        break;
                    }
                    case CURRENCY: {
                        break;
                    }
                }
                continue;
            }
            if (formField.getValueInjector() == null) continue;
            ValueInjector valueInjector = formField.getValueInjector();
            AbstractField<Object> field = formField.getField();
            Object value = field.getValue();
            valueInjector.inject(record, value);
        }
        entity.save();
        SessionContext.current().showNotification(this.getIcon(TeamAppsIconBundle.SAVE.getKey()), this.getLocalized(TeamAppsDictionary.RECORD_SUCCESSFULLY_SAVED.getKey(), new Object[0]));
    }

    public ResponsiveFormSection addSection() {
        ResponsiveFormSection section = this.formLayout.addSection();
        section.setDrawHeaderLine(false);
        section.setCollapsible(false);
        return section;
    }

    public ResponsiveFormSection addSection(Icon icon, String text) {
        return this.formLayout.addSection(icon, text);
    }

    @Override
    protected <VALUE> void handleNewField(Field<ENTITY, VALUE> field) {
        this.formLayout.addLabelAndField(field.getIcon(), field.getTitle(), field.getName(), field.getField());
    }
}

