/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.grouping;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.Field;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.filter.AbstractQueryFilter;
import org.teamapps.udb.filter.BooleanQueryFilter;
import org.teamapps.udb.filter.GroupFilter;
import org.teamapps.udb.filter.NumericQueryFilter;
import org.teamapps.udb.filter.TextQueryFilter;
import org.teamapps.udb.grouping.GroupingEntry;
import org.teamapps.udb.grouping.GroupingNode;
import org.teamapps.udb.grouping.GroupingNodeType;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.bool.BooleanFilter;
import org.teamapps.universaldb.index.numeric.NumericFilter;
import org.teamapps.universaldb.index.text.TextFilter;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.universaldb.query.AndFilter;
import org.teamapps.universaldb.query.Filter;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.animation.PageTransition;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.DisplayField;
import org.teamapps.ux.component.field.TemplateField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.TagBoxWrappingMode;
import org.teamapps.ux.component.field.combobox.TagComboBox;
import org.teamapps.ux.component.flexcontainer.VerticalLayout;
import org.teamapps.ux.component.mobile.MobileLayout;
import org.teamapps.ux.component.table.ListTableModel;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.component.toolbar.ToolbarButton;
import org.teamapps.ux.component.toolbar.ToolbarButtonGroup;
import org.teamapps.ux.component.tree.Tree;
import org.teamapps.ux.component.tree.TreeNodeInfoImpl;
import org.teamapps.ux.i18n.TeamAppsDictionary;
import org.teamapps.ux.icon.TeamAppsIconBundle;
import org.teamapps.ux.model.ListTreeModel;
import org.teamapps.ux.model.TreeModel;
import org.teamapps.ux.session.SessionContext;

public class GroupingView<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    private MobileLayout layout;
    private VerticalLayout verticalLayout;
    private TagComboBox<GroupFilter> filtersTagComboBox;
    private Tree<GroupingNode> filterSelectionTree;
    private Table<GroupingEntry> groupingEntryTable;
    private ListTableModel<GroupingEntry> listTableModel;
    private GroupingNode currentNode;
    private List<GroupFilter> groupFilters = new ArrayList<GroupFilter>();

    public GroupingView(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
    }

    private void createUi() {
        NumberFormat numberFormat = NumberFormat.getInstance(SessionContext.current().getLocale());
        this.layout = new MobileLayout();
        this.verticalLayout = new VerticalLayout();
        Toolbar toolbar = new Toolbar();
        this.verticalLayout.addComponent((Component)toolbar);
        this.filtersTagComboBox = new TagComboBox();
        this.filtersTagComboBox.setDropDownButtonVisible(false);
        this.filtersTagComboBox.setWrappingMode(TagBoxWrappingMode.SINGLE_TAG_PER_LINE);
        this.filtersTagComboBox.setShowClearButton(true);
        this.filtersTagComboBox.setTemplate((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        this.filtersTagComboBox.setPropertyExtractor((groupFilter, s) -> {
            switch (s) {
                case "caption": {
                    return groupFilter.getCaption();
                }
                case "icon": {
                    return this.getIcon(TeamAppsIconBundle.FILTER.getKey());
                }
            }
            return null;
        });
        DisplayField label = new DisplayField(false, true);
        label.setValue((Object)(this.getLocalized(TeamAppsDictionary.FILTER.getKey(), new Object[0]) + ":"));
        this.verticalLayout.addComponent((Component)label);
        this.verticalLayout.addComponent(this.filtersTagComboBox);
        this.listTableModel = new ListTableModel();
        this.groupingEntryTable = new Table();
        this.groupingEntryTable.setModel(this.listTableModel);
        this.groupingEntryTable.addColumn(new TableColumn("entry", this.getLocalized(TeamAppsDictionary.VALUES.getKey(), new Object[0]), (AbstractField)new TextField()).setDefaultWidth(250));
        TemplateField templateField = new TemplateField((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
        templateField.setPropertyExtractor((count, s) -> {
            switch (s) {
                case "badge": {
                    return count;
                }
            }
            return null;
        });
        this.groupingEntryTable.addColumn(new TableColumn("count", this.getLocalized(TeamAppsDictionary.COUNT.getKey(), new Object[0]), (AbstractField)templateField).setDefaultWidth(75));
        this.groupingEntryTable.setPropertyExtractor((entry, column) -> {
            switch (column) {
                case "entry": {
                    return entry.getValue();
                }
                case "count": {
                    return entry.getCountAsString(numberFormat);
                }
            }
            return null;
        });
        this.groupingEntryTable.setDisplayAsList(true);
        this.groupingEntryTable.setForceFitWidth(true);
        this.groupingEntryTable.setRowHeight(28);
        this.verticalLayout.addComponentFillRemaining(this.groupingEntryTable);
        ListTreeModel treeModel = new ListTreeModel(this.createNodes());
        treeModel.setTreeNodeInfoFunction(node -> new TreeNodeInfoImpl((Object)node.getParentNode(), false));
        this.filterSelectionTree = new Tree((TreeModel)treeModel);
        this.filterSelectionTree.setShowExpanders(false);
        this.filterSelectionTree.setOpenOnSelection(true);
        this.filterSelectionTree.setEntryTemplate((Template)BaseTemplate.LIST_ITEM_MEDIUM_ICON_SINGLE_LINE);
        this.filterSelectionTree.setPropertyExtractor((node, s) -> {
            switch (s) {
                case "icon": {
                    return node.getIcon();
                }
                case "caption": {
                    return node.getTitle();
                }
            }
            return null;
        });
        this.filterSelectionTree.onNodeSelected.addListener(node -> {
            if (node.getChildNodes() == null || node.getChildNodes().isEmpty()) {
                this.group((GroupingNode)node);
                this.layout.setContent((Component)this.verticalLayout, PageTransition.MOVE_TO_LEFT_VS_MOVE_FROM_RIGHT, 500);
            }
        });
        this.filtersTagComboBox.onValueChanged.addListener(list -> {
            this.groupFilters = list;
            this.getModelBuilderFactory().onGroupFilterChanged.fire((Object)this.createFilter(this.groupFilters));
        });
        this.groupingEntryTable.onRowSelected.addListener(entry -> this.addFilter((GroupingEntry)entry));
        ToolbarButtonGroup buttonGroup = toolbar.addButtonGroup(new ToolbarButtonGroup());
        buttonGroup.addButton((ToolbarButton)ToolbarButton.createTiny((Icon)this.getIcon((String)TeamAppsIconBundle.BACK.getKey()), (String)this.getLocalized((String)TeamAppsDictionary.BACK.getKey(), (Object[])new Object[0]))).onClick.addListener(() -> {
            this.layout.setContent(this.filterSelectionTree, PageTransition.MOVE_TO_RIGHT_VS_MOVE_FROM_LEFT, 500);
            this.currentNode = null;
        });
        buttonGroup.addButton((ToolbarButton)ToolbarButton.createTiny((Icon)this.getIcon((String)TeamAppsIconBundle.UNDO.getKey()), (String)this.getLocalized((String)TeamAppsDictionary.REMOVE_ALL_FILTERS.getKey(), (Object[])new Object[0]))).onClick.addListener(() -> {
            this.groupFilters.clear();
            this.filtersTagComboBox.setValue(this.groupFilters);
            this.getModelBuilderFactory().onGroupFilterChanged.fire((Object)this.createFilter(this.groupFilters));
        });
        this.getModelBuilderFactory().onTimeIntervalFilterChanged.addListener(() -> {
            if (this.currentNode != null) {
                this.group(this.currentNode);
            }
        });
        this.layout.setContent(this.filterSelectionTree);
    }

    public TextField createSearchHeaderField(String emptyText) {
        TextField textField = new TextField();
        textField.setEmptyText(emptyText);
        textField.setShowClearButton(true);
        textField.onTextInput.addListener(query -> this.listTableModel.setFilter(entry -> {
            if (query == null || query.isBlank()) {
                return true;
            }
            return entry.getValue().toLowerCase().contains(query.toLowerCase());
        }));
        return textField;
    }

    private void addFilter(GroupingEntry entry) {
        ColumnIndex index = this.currentNode.getIndex();
        GroupingNodeType nodeType = this.currentNode.getNodeType();
        AbstractQueryFilter queryFilter = null;
        if (nodeType == null || nodeType == GroupingNodeType.BY_VALUE) {
            switch (index.getType()) {
                case BOOLEAN: {
                    queryFilter = new BooleanQueryFilter(index.getName(), "true".equals(entry.getValue()) ? BooleanFilter.trueFilter() : BooleanFilter.falseFilter());
                    break;
                }
                case SHORT: 
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    queryFilter = new NumericQueryFilter(index.getName(), NumericFilter.equalsFilter((Number)Double.parseDouble(entry.getValue())));
                    break;
                }
                case TEXT: {
                    queryFilter = new TextQueryFilter(index.getName(), TextFilter.textEqualsFilter((String)entry.getValue()));
                }
            }
        } else if (nodeType == GroupingNodeType.TEXT_TERM) {
            queryFilter = new TextQueryFilter(index.getName(), TextFilter.termEqualsFilter((String)entry.getValue()));
        }
        if (queryFilter != null) {
            GroupFilter groupFilter = new GroupFilter(queryFilter, entry.getValue(), this.currentNode);
            this.groupFilters.add(groupFilter);
            this.filtersTagComboBox.setValue(this.groupFilters);
            this.getModelBuilderFactory().onGroupFilterChanged.fire((Object)this.createFilter(this.groupFilters));
        }
    }

    private Filter createFilter(List<GroupFilter> groupFilters) {
        if (groupFilters.isEmpty()) {
            return null;
        }
        AndFilter filter = new AndFilter();
        TableIndex tableIndex = this.getModelBuilderFactory().getTableIndex();
        groupFilters.stream().collect(Collectors.groupingBy(f -> f.getGroupingNode())).entrySet().forEach(arg_0 -> GroupingView.lambda$createFilter$14(tableIndex, (Filter)filter, arg_0));
        return filter;
    }

    private void group(GroupingNode node) {
        this.currentNode = node;
        ColumnIndex index = node.getIndex();
        GroupingNodeType type = node.getNodeType();
        BitSet records = this.getModelBuilderFactory().getGeoBitSet();
        if (type == null || type == GroupingNodeType.BY_VALUE || type == GroupingNodeType.TEXT_TERM) {
            ArrayList<Object> values = new ArrayList<Object>();
            boolean isTerm = type == GroupingNodeType.TEXT_TERM;
            int id = records.nextSetBit(0);
            while (id >= 0) {
                Object value = index.getStringValue(id);
                if (value == null || ((String)value).equals("NULL") || ((String)value).equals("0")) {
                    value = "(" + this.getLocalized(TeamAppsDictionary.EMPTY.getKey(), new Object[0]) + ")";
                }
                if (isTerm) {
                    for (String s2 : GroupingView.splitTerms((String)value)) {
                        if (s2.isBlank()) continue;
                        values.add(s2);
                    }
                } else {
                    values.add(value);
                }
                id = records.nextSetBit(id + 1);
            }
            List entries = values.stream().collect(Collectors.groupingBy(s -> s)).entrySet().stream().map(entry -> new GroupingEntry((String)entry.getKey(), ((List)entry.getValue()).size())).sorted(Comparator.comparingInt(GroupingEntry::getCount).reversed()).collect(Collectors.toList());
            this.listTableModel.setList(entries);
        }
    }

    private List<GroupingNode> createNodes() {
        ArrayList<GroupingNode> nodes = new ArrayList<GroupingNode>();
        List fields = this.getFields();
        if (fields.isEmpty()) {
            fields = this.getModelBuilderFactory().getFields();
        }
        for (Field field : fields) {
            String name = field.getName();
            ColumnIndex columnIndex = field.getIndex();
            if (columnIndex == null) continue;
            GroupingNode node = new GroupingNode(columnIndex, field.getTitle(), field.getIcon() != null ? field.getIcon() : this.getIcon(TeamAppsIconBundle.ENUM.getKey()));
            nodes.add(node);
            if (node.getChildNodes() == null) continue;
            nodes.addAll(node.getChildNodes());
        }
        return nodes;
    }

    public Component getView() {
        if (this.layout == null) {
            this.createUi();
        }
        return this.layout;
    }

    public Component createAndAttachToViewWithHeaderField(View view) {
        view.setComponent(this.getView());
        TextField searchHeaderField = this.createSearchHeaderField(this.getLocalized(TeamAppsDictionary.SEARCH___.getKey(), new Object[0]));
        view.getPanel().setRightHeaderField((AbstractField)searchHeaderField);
        return this.getView();
    }

    private static String[] splitTerms(String s) {
        if (s == null || s.isBlank()) {
            return null;
        }
        return s.split("[\\t,;.\\-:@\\[\\](){}_*/ ]");
    }

    private static /* synthetic */ void lambda$createFilter$14(TableIndex tableIndex, Filter filter, Map.Entry entry) {
        Filter subFilter = null;
        for (GroupFilter groupFilter : (List)entry.getValue()) {
            Filter orFilter = groupFilter.getQueryFilter().createFilter(tableIndex);
            if (subFilter == null) {
                subFilter = orFilter;
                continue;
            }
            subFilter = subFilter.or(orFilter);
        }
        filter.and(subFilter);
    }
}

