/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.perspectve;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.icons.api.Icon;
import org.teamapps.udb.Field;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.udb.perspectve.ViewType;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.template.Template;

public class ViewDefinition<ENTITY extends Entity<ENTITY>> {
    private final ViewType viewType;
    private final ModelBuilderFactory<ENTITY> modelBuilderFactory;
    private List<Field<ENTITY, ?>> fields = new ArrayList();
    private String layoutPosition;
    private String title;
    private Icon icon;
    private boolean displayInitially;
    private Template template;
    private PropertyExtractor<ENTITY> propertyExtractor;
    private int itemWidth;
    private int itemHeight;
    private String latitudeFieldName;
    private String longitudeFieldName;

    public ViewDefinition(ViewType viewType, ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        this.viewType = viewType;
        this.modelBuilderFactory = modelBuilderFactory;
        switch (viewType) {
            case TABLE: 
            case ITEM_VIEW: {
                this.layoutPosition = "center";
                this.displayInitially = true;
                break;
            }
            case FORM: {
                this.layoutPosition = "right";
                this.displayInitially = true;
                break;
            }
            case TIME_GRAPH: {
                this.layoutPosition = "top";
                this.displayInitially = true;
                break;
            }
            case MAP: {
                this.layoutPosition = "center-bottom";
                this.displayInitially = true;
                break;
            }
            case GROUPING_VIEW: {
                this.layoutPosition = "left-bottom";
                this.displayInitially = true;
            }
        }
    }

    protected ViewDefinition(ViewType viewType, ModelBuilderFactory<ENTITY> modelBuilderFactory, String title, Icon icon) {
        this(viewType, modelBuilderFactory);
        this.title = title;
        this.icon = icon;
    }

    protected ViewDefinition(ViewType viewType, ModelBuilderFactory<ENTITY> modelBuilderFactory, String layoutPosition, String title, Icon icon, boolean displayInitially) {
        this.viewType = viewType;
        this.modelBuilderFactory = modelBuilderFactory;
        this.layoutPosition = layoutPosition;
        this.title = title;
        this.icon = icon;
        this.displayInitially = displayInitially;
    }

    protected ViewDefinition(ViewType viewType, ModelBuilderFactory<ENTITY> modelBuilderFactory, String layoutPosition, String title, Icon icon, boolean displayInitially, Template template, PropertyExtractor<ENTITY> propertyExtractor, int itemWidth, int itemHeight) {
        this.viewType = viewType;
        this.modelBuilderFactory = modelBuilderFactory;
        this.layoutPosition = layoutPosition;
        this.title = title;
        this.icon = icon;
        this.displayInitially = displayInitially;
        this.template = template;
        this.propertyExtractor = propertyExtractor;
        this.itemWidth = itemWidth;
        this.itemHeight = itemHeight;
    }

    public View createView() {
        return View.createView((String)this.layoutPosition, (Icon)this.icon, (String)this.title, null);
    }

    public ViewType getViewType() {
        return this.viewType;
    }

    public String getLayoutPosition() {
        return this.layoutPosition;
    }

    public void setLayoutPosition(String layoutPosition) {
        this.layoutPosition = layoutPosition;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isDisplayInitially() {
        return this.displayInitially;
    }

    public void setDisplayInitially(boolean displayInitially) {
        this.displayInitially = displayInitially;
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public PropertyExtractor<ENTITY> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<ENTITY> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public int getItemWidth() {
        return this.itemWidth;
    }

    public void setItemWidth(int itemWidth) {
        this.itemWidth = itemWidth;
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public void setItemHeight(int itemHeight) {
        this.itemHeight = itemHeight;
    }

    public void setLocationFieldNames(String latitudeFieldName, String longitudeFieldName) {
        this.latitudeFieldName = latitudeFieldName;
        this.longitudeFieldName = longitudeFieldName;
    }

    public String getLatitudeFieldName() {
        return this.latitudeFieldName;
    }

    public String getLongitudeFieldName() {
        return this.longitudeFieldName;
    }

    public List<Field<ENTITY, ?>> getFields() {
        return this.fields;
    }

    public void addFieldCopies(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.addFieldCopy(fieldName);
        }
    }

    public Field<ENTITY, ?> addFieldCopy(String fieldName) {
        Field field = this.modelBuilderFactory.getFields().stream().filter(f -> f.getName().equals(fieldName)).findAny().orElseThrow();
        Field newField = field.copy();
        this.addField(newField);
        return newField;
    }

    public <VALUE> void addFields(Field<ENTITY, VALUE> ... fields) {
        for (Field<ENTITY, VALUE> field : fields) {
            this.addField(field);
        }
    }

    public <VALUE> Field<ENTITY, VALUE> addField(String fieldName, String title) {
        return this.addField(fieldName, title, null);
    }

    public <VALUE> Field<ENTITY, VALUE> addField(String fieldName, String title, Icon icon) {
        ColumnIndex index = this.modelBuilderFactory.getTableIndex().getColumnIndex(fieldName);
        Field field = Field.createField(fieldName, title, icon, index);
        return this.addField(field);
    }

    public <VALUE> Field<ENTITY, VALUE> addField(Field<ENTITY, VALUE> field) {
        if (field.getField() == null) {
            return null;
        }
        this.fields.add(field);
        return field;
    }
}

