/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.data.extract.ValueExtractor;
import org.teamapps.data.extract.ValueInjector;
import org.teamapps.icons.Icon;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.index.reference.multi.MultiReferenceIndex;
import org.teamapps.universaldb.index.reference.single.SingleReferenceIndex;
import org.teamapps.universaldb.index.text.TextIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.field.CheckBox;
import org.teamapps.ux.component.field.FieldEditingMode;
import org.teamapps.ux.component.field.NumberField;
import org.teamapps.ux.component.field.TextField;
import org.teamapps.ux.component.field.combobox.ComboBox;
import org.teamapps.ux.component.field.datetime.InstantDateTimeField;
import org.teamapps.ux.component.field.datetime.LocalDateField;
import org.teamapps.ux.component.field.datetime.LocalTimeField;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.icon.TeamAppsIconBundle;

public class Field<ENTITY extends Entity<ENTITY>, VALUE> {
    private final String name;
    private final ColumnIndex index;
    private final boolean customField;
    private String title;
    private Icon icon;
    private boolean editable = true;
    private boolean required;
    private AbstractField<VALUE> field;
    private ValueExtractor<ENTITY> valueExtractor;
    private ValueInjector<ENTITY, VALUE> valueInjector;

    public static <ENTITY extends Entity<ENTITY>, VALUE> Field<ENTITY, VALUE> copy(Field<ENTITY, VALUE> field) {
        return new Field<ENTITY, VALUE>(field);
    }

    public static <ENTITY extends Entity<ENTITY>, VALUE> Field<ENTITY, VALUE> createCustomField(String name) {
        return new Field<ENTITY, VALUE>(name);
    }

    public static <ENTITY extends Entity<ENTITY>, VALUE> Field<ENTITY, VALUE> createField(String name, String title, ColumnIndex index) {
        return Field.createField(name, title, null, index);
    }

    public static <ENTITY extends Entity<ENTITY>, VALUE> Field<ENTITY, VALUE> createField(String name, String title, Icon icon, ColumnIndex index) {
        return new Field<ENTITY, VALUE>(name, title, icon, index);
    }

    public static <ENTITY extends Entity<ENTITY>, VALUE> Field<ENTITY, VALUE> createField(String fieldName, String title, Icon icon, ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        return new Field<ENTITY, VALUE>(fieldName, title, icon, true, false, modelBuilderFactory);
    }

    public static <ENTITY extends Entity<ENTITY>, VALUE> Field<ENTITY, VALUE> createField(String fieldName, String title, Icon icon, boolean editable, boolean required, ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        return new Field<ENTITY, VALUE>(fieldName, title, icon, editable, required, modelBuilderFactory);
    }

    protected Field(Field<ENTITY, VALUE> field) {
        this.name = field.getName();
        this.title = field.getTitle();
        this.index = field.getIndex();
        this.customField = field.isCustomField();
        this.editable = field.isEditable();
        this.required = field.isRequired();
        this.valueExtractor = field.getValueExtractor();
        this.valueInjector = field.getValueInjector();
        if (this.index != null) {
            this.field = Field.createField(this.index, this.title);
        }
    }

    protected Field(String name, String title, Icon icon, ColumnIndex index) {
        this.name = name;
        this.index = index;
        this.customField = false;
        this.field = Field.createField(index, title);
        this.title = title;
        this.icon = icon;
    }

    protected Field(String name) {
        this.name = name;
        this.index = null;
        this.customField = true;
    }

    protected Field(String fieldName, String title, Icon icon, boolean editable, boolean required, ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        this.name = fieldName;
        this.index = modelBuilderFactory.getTableIndex().getColumnIndex(fieldName);
        this.field = Field.createField(this.index, title);
        this.title = title;
        this.icon = icon;
        this.editable = editable;
        this.required = required;
        this.customField = false;
    }

    public Field<ENTITY, VALUE> copy() {
        return new Field<ENTITY, VALUE>(this);
    }

    public boolean isCustomField() {
        return this.customField;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        return this.title;
    }

    public Field<ENTITY, VALUE> setTitle(String title) {
        this.title = title;
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Field<ENTITY, VALUE> setIcon(Icon icon) {
        this.icon = icon;
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public Field<ENTITY, VALUE> setEditable(boolean editable) {
        this.editable = editable;
        this.field.setEditingMode(editable ? FieldEditingMode.EDITABLE : FieldEditingMode.READONLY);
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public Field<ENTITY, VALUE> setRequired(boolean required) {
        this.required = required;
        this.field.setRequired(required);
        return this;
    }

    public AbstractField<VALUE> getField() {
        return this.field;
    }

    public Field<ENTITY, VALUE> setField(AbstractField<VALUE> field) {
        this.field = field;
        if (this.required) {
            field.setRequired(true);
        }
        return this;
    }

    public ValueExtractor<ENTITY> getValueExtractor() {
        return this.valueExtractor;
    }

    public Field<ENTITY, VALUE> setValueExtractor(ValueExtractor<ENTITY> valueExtractor) {
        this.valueExtractor = valueExtractor;
        return this;
    }

    public ValueInjector<ENTITY, VALUE> getValueInjector() {
        return this.valueInjector;
    }

    public Field<ENTITY, VALUE> setValueInjector(ValueInjector<ENTITY, VALUE> valueInjector) {
        this.valueInjector = valueInjector;
        return this;
    }

    public ColumnIndex getIndex() {
        return this.index;
    }

    public static AbstractField createField(ColumnIndex columnIndex, String title) {
        TextField field = null;
        switch (columnIndex.getColumnType()) {
            case BOOLEAN: 
            case BITSET_BOOLEAN: {
                field = new CheckBox(title);
                break;
            }
            case SHORT: 
            case INT: 
            case LONG: {
                field = new NumberField(0);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                field = new NumberField(-1);
                break;
            }
            case TEXT: 
            case TRANSLATABLE_TEXT: {
                field = new TextField();
                break;
            }
            case FILE: {
                break;
            }
            case SINGLE_REFERENCE: {
                SingleReferenceIndex singleReferenceIndex = (SingleReferenceIndex)columnIndex;
                TableIndex referencedTable = singleReferenceIndex.getReferencedTable();
                List textIndices = referencedTable.getColumnIndices().stream().filter(c -> c.getColumnType() == ColumnType.TEXT).limit(5L).map(c -> (TextIndex)c).collect(Collectors.toList());
                ComboBox referenceCombo = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
                referenceCombo.setPropertyExtractor((entity, propertyName) -> {
                    switch (propertyName) {
                        case "icon": {
                            if (entity != null) {
                                return TeamAppsIconBundle.REFERENCE.getIcon();
                            }
                        }
                        case "caption": {
                            if (entity == null) break;
                            return entity.getId() + ": " + textIndices.stream().filter(t -> t.getValue(entity.getId()) != null).map(t -> t.getValue(entity.getId())).collect(Collectors.joining(", "));
                        }
                    }
                    return null;
                });
                field = referenceCombo;
                break;
            }
            case MULTI_REFERENCE: {
                MultiReferenceIndex multiReferenceIndex = (MultiReferenceIndex)columnIndex;
                ComboBox multiRefCombo = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
                multiRefCombo.setPropertyExtractor((list, propertyName) -> {
                    switch (propertyName) {
                        case "icon": {
                            return TeamAppsIconBundle.MULTI_REFERENCE.getIcon();
                        }
                        case "caption": {
                            if (list == null) break;
                            String ids = list.stream().limit(5L).map(e -> "" + e.getId()).collect(Collectors.joining(", "));
                            return list.size() > 5 ? ids + " (" + list.size() + ")" : ids;
                        }
                    }
                    return null;
                });
                field = multiRefCombo;
                break;
            }
            case TIMESTAMP: 
            case DATE_TIME: {
                field = new InstantDateTimeField();
                break;
            }
            case DATE: {
                field = new LocalDateField();
                break;
            }
            case TIME: {
                field = new LocalTimeField();
                break;
            }
            case LOCAL_DATE: {
                field = new LocalDateField();
                break;
            }
            case ENUM: {
                ComboBox comboBox = new ComboBox((Template)BaseTemplate.LIST_ITEM_SMALL_ICON_SINGLE_LINE);
                comboBox.setPropertyExtractor((enumValue, propertyName) -> {
                    switch (propertyName) {
                        case "icon": {
                            if (enumValue != null) {
                                return TeamAppsIconBundle.ENUM.getIcon();
                            }
                        }
                        case "caption": {
                            if (enumValue == null) break;
                            return enumValue.name();
                        }
                    }
                    return null;
                });
                field = comboBox;
                break;
            }
            case BINARY: {
                break;
            }
            case CURRENCY: {
                break;
            }
        }
        return field;
    }
}

