/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.util.List;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.Field;
import org.teamapps.udb.HeaderFieldBuilder;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.table.Table;
import org.teamapps.ux.component.table.TableColumn;
import org.teamapps.ux.component.table.TableModel;

public class TableBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    protected TableBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
    }

    private TableColumn<ENTITY> createColumn(Field<ENTITY, ?> field) {
        if (field.getField() == null) {
            return null;
        }
        return new TableColumn(field.getName(), field.getIcon(), field.getTitle(), field.getField());
    }

    public Table<ENTITY> build() {
        TableModel tableModel = this.getModelBuilderFactory().createTableModelBuilder().createTableModel();
        Table table = new Table();
        table.setModel(tableModel);
        List fields = this.getFields();
        if (fields.isEmpty()) {
            fields = this.getModelBuilderFactory().getFields();
        }
        for (Field field : fields) {
            TableColumn column = this.createColumn(field);
            if (column == null) continue;
            table.addColumn(column);
        }
        table.onRowSelected.addListener(entity -> this.getModelBuilderFactory().onRecordSelected.fire(entity));
        return table;
    }

    public Table<ENTITY> createAndAttachToViewWithHeaderField(View view) {
        Table<ENTITY> table = this.build();
        view.setComponent(table);
        HeaderFieldBuilder headerFieldBuilder = this.getModelBuilderFactory().createHeaderFieldBuilder();
        headerFieldBuilder.setSearchHeaderField(view);
        headerFieldBuilder.setHeaderTitleHandler(view, view.getPanel().getTitle());
        return table;
    }
}

