/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.udb.AbstractBuilder;
import org.teamapps.udb.Field;
import org.teamapps.udb.ModelBuilderFactory;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.IndexType;
import org.teamapps.universaldb.index.numeric.IntegerIndex;
import org.teamapps.universaldb.index.numeric.LongIndex;
import org.teamapps.universaldb.pojo.Entity;
import org.teamapps.ux.component.timegraph.TimeGraphModel;
import org.teamapps.ux.component.timegraph.partitioning.StaticPartitioningTimeGraphModel;
import org.teamapps.ux.session.SessionContext;

public class TimeGraphModelBuilder<ENTITY extends Entity<ENTITY>>
extends AbstractBuilder<ENTITY> {
    private String queryFieldName;
    private StaticPartitioningTimeGraphModel timeGraphModel;

    protected TimeGraphModelBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory) {
        super(modelBuilderFactory);
        this.init();
    }

    protected TimeGraphModelBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory, String ... fieldNames) {
        super(modelBuilderFactory);
        this.addFieldCopies(fieldNames);
        this.init();
    }

    protected TimeGraphModelBuilder(ModelBuilderFactory<ENTITY> modelBuilderFactory, List<Field<ENTITY, ?>> fields) {
        super(modelBuilderFactory);
        fields.forEach(this::addField);
        this.init();
    }

    private void init() {
        this.timeGraphModel = StaticPartitioningTimeGraphModel.create((ZoneId)SessionContext.current().getTimeZone());
        List<Field<ENTITY, ?>> dateFields = this.getDateFields();
        if (!dateFields.isEmpty()) {
            this.queryFieldName = dateFields.get(0).getName();
        }
    }

    public List<Field<ENTITY, ?>> getDateFields() {
        return this.getFields().stream().filter(f -> TimeGraphModelBuilder.isDateField(f)).collect(Collectors.toList());
    }

    public static <ENTITY extends Entity<ENTITY>> boolean isDateField(Field<ENTITY, ?> field) {
        ColumnIndex column = field.getIndex();
        return column != null && (column.getColumnType() == ColumnType.TIMESTAMP || column.getColumnType() == ColumnType.DATE_TIME || column.getColumnType() == ColumnType.LOCAL_DATE || column.getColumnType() == ColumnType.DATE);
    }

    public void setQueryFieldName(String fieldName) {
        this.queryFieldName = fieldName;
        this.updateBaseData();
        this.updateGroupFilterData();
        this.updateFullTextFilterData();
    }

    public String getQueryFieldName() {
        return this.queryFieldName;
    }

    private void updateBaseData() {
        BitSet recordSet = this.getModelBuilderFactory().getBaseBitSet();
        long[] timestamps = this.queryTimestamps(recordSet, this.queryFieldName);
        this.timeGraphModel.setEventTimestampsForDataSeriesId("baseData", timestamps);
    }

    private void updateGeoFilterData() {
        if (this.getModelBuilderFactory().getGeoFilter() != null) {
            BitSet recordSet = this.getModelBuilderFactory().getGeoBitSet();
            long[] timestamps = this.queryTimestamps(recordSet, this.queryFieldName);
            this.timeGraphModel.setEventTimestampsForDataSeriesId("geoData", timestamps);
        }
    }

    private void updateGroupFilterData() {
        if (this.getModelBuilderFactory().getGroupFilter() != null) {
            BitSet recordSet = this.getModelBuilderFactory().getGroupingBitSet();
            long[] timestamps = this.queryTimestamps(recordSet, this.queryFieldName);
            this.timeGraphModel.setEventTimestampsForDataSeriesId("groupData", timestamps);
        }
    }

    private void updateFullTextFilterData() {
        if (this.getModelBuilderFactory().getFullTextQuery() != null && !this.getModelBuilderFactory().getFullTextQuery().isBlank()) {
            BitSet recordSet = this.getModelBuilderFactory().getFinalBitSet();
            long[] timestamps = this.queryTimestamps(recordSet, this.queryFieldName);
            this.timeGraphModel.setEventTimestampsForDataSeriesId("fullTextData", timestamps);
        }
    }

    private long[] queryTimestamps(BitSet recordSet, String fieldName) {
        ColumnIndex columnIndex = this.getModelBuilderFactory().getTableIndex().getColumnIndex(fieldName);
        IntegerIndex integerIndex = null;
        LongIndex longIndex = null;
        if (columnIndex.getType() == IndexType.INT) {
            integerIndex = (IntegerIndex)columnIndex;
        } else {
            longIndex = (LongIndex)columnIndex;
        }
        ArrayList<Long> values = new ArrayList<Long>();
        int id = recordSet.nextSetBit(0);
        while (id >= 0) {
            long value2;
            long l = value2 = integerIndex != null ? (long)integerIndex.getValue(id) * 1000L : longIndex.getValue(id);
            if (value2 != 0L) {
                values.add(value2);
            }
            id = recordSet.nextSetBit(id + 1);
        }
        return values.stream().mapToLong(value -> value).toArray();
    }

    public TimeGraphModel build() {
        this.getModelBuilderFactory().onBaseQueryDataChanged.addListener(() -> this.updateBaseData());
        this.getModelBuilderFactory().onGeoDataChanged.addListener(() -> this.updateGeoFilterData());
        this.getModelBuilderFactory().onGroupingDataChanged.addListener(() -> this.updateGroupFilterData());
        this.getModelBuilderFactory().onFinalDataChanged.addListener(() -> this.updateFullTextFilterData());
        this.updateBaseData();
        this.updateGroupFilterData();
        this.updateFullTextFilterData();
        return this.timeGraphModel;
    }
}

