/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.app;

import java.io.File;
import java.util.function.Supplier;
import org.teamapps.udb.app.WebServer;
import org.teamapps.universaldb.UniversalDB;
import org.teamapps.universaldb.schema.SchemaInfoProvider;
import org.teamapps.ux.component.Component;
import org.teamapps.webcontroller.WebController;

public class Server {
    private final File dbDir;
    private final File path;
    private final SchemaInfoProvider schema;
    private final WebServer webServer;
    private UniversalDB database;

    public Server(File path, SchemaInfoProvider schema) {
        this.dbDir = new File(path, "database");
        this.path = path;
        this.schema = schema;
        this.dbDir.mkdir();
        this.webServer = new WebServer();
    }

    public WebController getWebController() {
        return this.webServer.getWebController();
    }

    public void startServer(Supplier<Component> applicationSupplier) throws Exception {
        this.startServer(8080, applicationSupplier);
    }

    public void startServer(int port, Supplier<Component> applicationSupplier) throws Exception {
        this.database = UniversalDB.createStandalone((File)new File(this.path, "database"), (SchemaInfoProvider)this.schema);
        this.webServer.setPort(port);
        this.webServer.startServer(applicationSupplier);
    }

    public UniversalDB getDatabase() {
        return this.database;
    }
}

