/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.udb.explorer;

import java.text.NumberFormat;
import java.util.stream.Collectors;
import org.teamapps.common.format.Color;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.udb.explorer.NodeType;
import org.teamapps.udb.explorer.Util;
import org.teamapps.universaldb.index.ColumnIndex;
import org.teamapps.universaldb.index.ColumnType;
import org.teamapps.universaldb.index.DatabaseIndex;
import org.teamapps.universaldb.index.SchemaIndex;
import org.teamapps.universaldb.index.TableIndex;
import org.teamapps.universaldb.schema.TableOption;

public class Node {
    private final String name;
    private final NodeType type;
    private final Object data;
    private final Node parent;

    public Node(String name, NodeType type, Object data, Node parent) {
        this.name = Util.createTitleFromCamelCase(name);
        this.type = type;
        this.data = data;
        this.parent = parent;
    }

    public Node(String name, NodeType type, Object data) {
        this.parent = null;
        this.name = Util.createTitleFromCamelCase(name);
        this.type = type;
        this.data = data;
    }

    public String getName() {
        return this.name;
    }

    public NodeType getType() {
        return this.type;
    }

    public Object getData() {
        return this.data;
    }

    public Node getParent() {
        return this.parent;
    }

    public SchemaIndex getSchemaIndex() {
        return (SchemaIndex)this.data;
    }

    public DatabaseIndex getDatabaseIndex() {
        return (DatabaseIndex)this.data;
    }

    public TableIndex getTableIndex() {
        return (TableIndex)this.data;
    }

    public ColumnIndex getColumnIndex() {
        return (ColumnIndex)this.data;
    }

    public boolean hasReferences() {
        if (this.type != NodeType.COLUMN) {
            return false;
        }
        ColumnType columnType = this.getColumnIndex().getColumnType();
        return columnType.isReference();
    }

    public String getDescription() {
        switch (this.type) {
            case SCHEMA: {
                return this.getSchemaIndex().getPath().toString();
            }
            case DATABASE: {
                return this.getDatabaseIndex().getFQN();
            }
            case TABLE: {
                return this.getTableIndex().getTableConfig().getTableOptions().stream().map(option -> Node.getTableOptionTitle(option)).collect(Collectors.joining(", "));
            }
            case COLUMN: {
                return this.getColumnIndex().getColumnType().name();
            }
        }
        return null;
    }

    public String getBadge(NumberFormat numberFormat) {
        switch (this.type) {
            case SCHEMA: {
                return this.getSchemaIndex().getDatabases().size() + " DBs";
            }
            case DATABASE: {
                return this.getDatabaseIndex().getTables().size() + " TBLs";
            }
            case TABLE: {
                return numberFormat.format(this.getTableIndex().getCount());
            }
        }
        return null;
    }

    public Color getColor() {
        switch (this.type) {
            case SCHEMA: {
                return Color.MATERIAL_RED_900;
            }
            case DATABASE: {
                return Color.MATERIAL_GREEN_900;
            }
            case TABLE: {
                return Color.MATERIAL_BLUE_900;
            }
            case COLUMN: {
                return Color.MATERIAL_AMBER_900;
            }
        }
        return null;
    }

    public Color getBackgroundColor() {
        switch (this.type) {
            case SCHEMA: {
                return Color.MATERIAL_RED_200;
            }
            case DATABASE: {
                return Color.MATERIAL_GREEN_200;
            }
            case TABLE: {
                return Color.MATERIAL_BLUE_200;
            }
            case COLUMN: {
                return Color.MATERIAL_AMBER_200;
            }
        }
        return null;
    }

    private static String getTableOptionTitle(TableOption option) {
        switch (option) {
            case CHECKPOINTS: {
                return "Checkpoints";
            }
            case VERSIONING: {
                return "Versions";
            }
            case HIERARCHY: {
                return "Hierarchy";
            }
            case TRACK_CREATION: {
                return "Creations";
            }
            case TRACK_MODIFICATION: {
                return "Modifications";
            }
            case KEEP_DELETED: {
                return "Deletions";
            }
        }
        return null;
    }

    public static PropertyExtractor<Node> createPropertyExtractor(NumberFormat numberFormat) {
        return (node, propertyName) -> {
            switch (propertyName) {
                case "icon": {
                    return node.getType().getIcon();
                }
                case "caption": {
                    return node.getName();
                }
                case "description": {
                    return node.getDescription();
                }
                case "badge": {
                    return node.getBadge(numberFormat);
                }
            }
            return null;
        };
    }
}

