/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet.util;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.ux.servlet.util.ZlibUtil;

public class ZipRatioAnalyzer {
    private static Logger LOGGER = LoggerFactory.getLogger(ZipRatioAnalyzer.class);
    public final String name;
    private AtomicLong uncompressedSizeSum = new AtomicLong(0L);
    private AtomicLong statefullyCompressedSizeSum = new AtomicLong(0L);
    private AtomicLong statelesslyCompressedSizeSum = new AtomicLong(0L);

    public ZipRatioAnalyzer(String name) {
        this.name = name;
    }

    public void addData(byte[] uncompressedData, int statefullyCompressedSize) {
        if (LOGGER.isDebugEnabled()) {
            long uncompressedSum = this.uncompressedSizeSum.addAndGet(uncompressedData.length);
            long statefulSum = this.statefullyCompressedSizeSum.addAndGet(statefullyCompressedSize);
            long statelessSum = this.statelesslyCompressedSizeSum.addAndGet(ZlibUtil.deflate(uncompressedData).length);
            LOGGER.debug(this.name + ":: \u03a3 uncompressed: " + FileUtils.byteCountToDisplaySize((long)uncompressedSum) + "; \u03a3 stateless: " + FileUtils.byteCountToDisplaySize((long)statelessSum) + " (r=" + this.ratio(uncompressedSum, statelessSum) + "); \u03a3 stateful: " + FileUtils.byteCountToDisplaySize((long)statefulSum) + " (r=" + this.ratio(uncompressedSum, statefulSum) + "); Ratio stateful vs. stateless: " + this.ratio(statelessSum, statefulSum));
        }
    }

    private String ratio(long uncompressedSize, long compressedSize) {
        return String.format("%.2f%%", Float.valueOf((float)(100L * (uncompressedSize - compressedSize)) / (float)uncompressedSize));
    }
}

