/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.UUID;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRegistration;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.json.TeamAppsObjectMapperFactory;
import org.teamapps.server.ServletRegistration;
import org.teamapps.uisession.TeamAppsUiSessionManager;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.ux.servlet.DownloadHttpHeaderFilter;
import org.teamapps.ux.servlet.LeaveBeaconServlet;
import org.teamapps.ux.servlet.ServletRequestListener;
import org.teamapps.ux.servlet.TeamAppsCommunicationEndpoint;
import org.teamapps.ux.servlet.TeamAppsUxClientGate;
import org.teamapps.ux.servlet.UploadServlet;
import org.teamapps.ux.servlet.WebSocketServerEndpointConfigurator;
import org.teamapps.webcontroller.WebController;

public class TeamAppsServletContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsServletContextListener.class);
    private WebController webController;
    private TeamAppsUiSessionManager uiSessionManager;

    public TeamAppsServletContextListener() {
        this(null);
    }

    public TeamAppsServletContextListener(WebController webController) {
        this.webController = webController;
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        WebController webController;
        ServletContext context = servletContextEvent.getServletContext();
        WebController webController2 = webController = this.webController != null ? this.webController : this.getWebController(context);
        if (webController == null) {
            throw new IllegalArgumentException("No WebController specified!");
        }
        ObjectMapper objectMapper = TeamAppsObjectMapperFactory.create();
        this.uiSessionManager = new TeamAppsUiSessionManager(objectMapper);
        TeamAppsUxClientGate teamAppsUxClientGate = new TeamAppsUxClientGate(webController, (UiCommandExecutor)this.uiSessionManager, objectMapper);
        this.uiSessionManager.setUiSessionListener((UiSessionListener)teamAppsUxClientGate);
        context.addFilter("teamapps-download-header-filter", (Filter)new DownloadHttpHeaderFilter()).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"*"});
        ServletRegistration.Dynamic uploadServletRegistration = context.addServlet("teamapps-upload-servlet", (Servlet)new UploadServlet((file, uuid) -> teamAppsUxClientGate.handleFileUpload((File)file, (String)uuid)));
        uploadServletRegistration.addMapping(new String[]{"/upload/*"});
        uploadServletRegistration.setMultipartConfig(new MultipartConfigElement(null, -1L, -1L, 1000000));
        ServletRegistration.Dynamic leaveBeaconServletRegistration = context.addServlet("teamapps-leave", (Servlet)new LeaveBeaconServlet(this.uiSessionManager));
        leaveBeaconServletRegistration.addMapping(new String[]{"/leave/*"});
        context.addListener((EventListener)((Object)new ServletRequestListener()));
        context.addListener((EventListener)this.uiSessionManager);
        try {
            ServerContainer serverContainer = (ServerContainer)servletContextEvent.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
            ServerEndpointConfig communicationEndpointConfig = ServerEndpointConfig.Builder.create(TeamAppsCommunicationEndpoint.class, (String)"/communication").configurator((ServerEndpointConfig.Configurator)new WebSocketServerEndpointConfigurator(this.uiSessionManager)).build();
            serverContainer.addEndpoint(communicationEndpointConfig);
        }
        catch (Exception e) {
            String msg = "Could not register TeamApps communication endpoint";
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg, e);
        }
        Collection<ServletRegistration> servletRegistrations = teamAppsUxClientGate.getServletRegistrations();
        for (ServletRegistration servletRegistration : servletRegistrations) {
            for (String mapping : servletRegistration.getMappings()) {
                LOGGER.info("Registering servlet on url path: " + mapping);
                context.addServlet("teamapps-registered-" + servletRegistration.getServlet().getClass().getSimpleName() + UUID.randomUUID().toString(), servletRegistration.getServlet()).addMapping(new String[]{mapping});
            }
        }
    }

    private WebController getWebController(ServletContext context) {
        if (this.webController != null) {
            return this.webController;
        }
        String classNameInitParameter = context.getInitParameter("teamapps.webController.className");
        if (classNameInitParameter != null) {
            try {
                return (WebController)Class.forName(classNameInitParameter).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                String msg = "Could instantiate WebController";
                LOGGER.error(msg, (Throwable)e);
                throw new IllegalArgumentException(msg, e);
            }
        }
        throw new IllegalArgumentException("No WebController specified!");
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.uiSessionManager.destroy();
        this.webController.destroy();
    }
}

