/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.AbstractClientMessage;
import org.teamapps.dto.AbstractServerMessage;
import org.teamapps.dto.CMD_REQUEST;
import org.teamapps.dto.CMD_RESULT;
import org.teamapps.dto.EVENT;
import org.teamapps.dto.INIT;
import org.teamapps.dto.KEEPALIVE;
import org.teamapps.dto.REINIT;
import org.teamapps.dto.SERVER_ERROR;
import org.teamapps.dto.TERMINATE;
import org.teamapps.json.TeamAppsObjectMapperFactory;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.SendingErrorHandler;
import org.teamapps.uisession.SessionClosingReason;
import org.teamapps.uisession.TeamAppsSessionNotFoundException;
import org.teamapps.uisession.TeamAppsUiSessionManager;
import org.teamapps.ux.servlet.ServerSideClientInfo;
import org.teamapps.ux.servlet.TeamAppsCommunicationException;
import org.teamapps.ux.servlet.util.ZipRatioAnalyzer;
import org.teamapps.ux.servlet.util.ZlibStatefulDeflater;
import org.teamapps.ux.servlet.util.ZlibStatefulInflater;

public class TeamAppsCommunicationEndpoint
extends Endpoint {
    private static final int MAX_BINARY_CLIENT_MESSAGE_SIZE = 0x100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsCommunicationEndpoint.class);
    private ObjectMapper mapper = TeamAppsObjectMapperFactory.create();
    private TeamAppsUiSessionManager sessionManager;

    public TeamAppsCommunicationEndpoint(TeamAppsUiSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.setMaxIdleTimeout(0x100000L);
        session.setMaxBinaryMessageBufferSize(0x100000);
        session.addMessageHandler((MessageHandler)new WebSocketHandler(session));
    }

    public void onError(Session session, Throwable thr) {
        this.closeWebSocketSession(session);
    }

    public void onClose(Session session, CloseReason closeReason) {
    }

    private void closeWebSocketSession(Session wsSession) {
        try {
            wsSession.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class WebSocketHandler
    implements MessageHandler.Whole<ByteBuffer> {
        private final Session wsSession;
        private final ZlibStatefulDeflater deflater = new ZlibStatefulDeflater();
        private final ZlibStatefulInflater inflater = new ZlibStatefulInflater();
        private ZipRatioAnalyzer sendingZipRatioAnalyzer = new ZipRatioAnalyzer("-> SEND");
        private ZipRatioAnalyzer receivingZipRatioAnalyzer = new ZipRatioAnalyzer("<- RECEIVE");

        public WebSocketHandler(Session session) {
            this.wsSession = session;
        }

        public void onMessage(ByteBuffer payload) {
            block10: {
                try {
                    HttpSession httpSession = (HttpSession)this.wsSession.getUserProperties().get("HTTP_SESSION");
                    byte[] compressed = new byte[payload.remaining()];
                    payload.get(compressed);
                    byte[] uncompressed = this.inflater.inflate(compressed);
                    String messageString = new String(uncompressed, StandardCharsets.UTF_8);
                    this.receivingZipRatioAnalyzer.addData(uncompressed, compressed.length);
                    AbstractClientMessage clientMessage = (AbstractClientMessage)TeamAppsCommunicationEndpoint.this.mapper.readValue(messageString, AbstractClientMessage.class);
                    QualifiedUiSessionId qualifiedUiSessionId = new QualifiedUiSessionId(httpSession.getId(), clientMessage.getSessionId());
                    ServerSideClientInfo serverSideClientInfo = this.createServerSideClientInfo(this.wsSession);
                    if (clientMessage instanceof INIT) {
                        INIT init = (INIT)clientMessage;
                        init.getClientInfo().setIp(serverSideClientInfo.getIp());
                        init.getClientInfo().setUserAgentString(serverSideClientInfo.getUserAgentString());
                        init.getClientInfo().setPreferredLanguageIso(serverSideClientInfo.getPreferredLanguageIso());
                        TeamAppsCommunicationEndpoint.this.sessionManager.initSession(qualifiedUiSessionId, init.getClientInfo(), init.getMaxRequestedCommandId(), (msg, sendingErrorHandler) -> this.send(this.wsSession, msg, null, sendingErrorHandler));
                        break block10;
                    }
                    if (clientMessage instanceof REINIT) {
                        REINIT reinit = (REINIT)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.reinitSession(qualifiedUiSessionId, reinit.getLastReceivedCommandId(), reinit.getMaxRequestedCommandId(), (msg, sendingErrorHandler) -> this.send(this.wsSession, msg, null, sendingErrorHandler));
                        break block10;
                    }
                    if (clientMessage instanceof TERMINATE) {
                        TeamAppsCommunicationEndpoint.this.sessionManager.closeSession(qualifiedUiSessionId, SessionClosingReason.TERMINATED_BY_CLIENT);
                        break block10;
                    }
                    if (clientMessage instanceof EVENT) {
                        EVENT eventMessage = (EVENT)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleEvent(qualifiedUiSessionId, eventMessage.getId(), eventMessage.getUiEvent());
                        break block10;
                    }
                    if (clientMessage instanceof CMD_RESULT) {
                        CMD_RESULT cmdResult = (CMD_RESULT)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleCommandResult(qualifiedUiSessionId, cmdResult.getId(), cmdResult.getCmdId(), cmdResult.getResult());
                        break block10;
                    }
                    if (clientMessage instanceof CMD_REQUEST) {
                        CMD_REQUEST cmdRequest = (CMD_REQUEST)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleCommandRequest(qualifiedUiSessionId, cmdRequest.getLastReceivedCommandId(), cmdRequest.getMaxRequestedCommandId());
                        break block10;
                    }
                    if (clientMessage instanceof KEEPALIVE) {
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleKeepAlive(qualifiedUiSessionId);
                        break block10;
                    }
                    throw new TeamAppsCommunicationException("Unknown message type: " + clientMessage.getClass().getCanonicalName());
                }
                catch (TeamAppsSessionNotFoundException e) {
                    LOGGER.warn("TeamApps session not found: " + e.getSessionId());
                    this.send(this.wsSession, (AbstractServerMessage)new SERVER_ERROR(SERVER_ERROR.Reason.SESSION_NOT_FOUND).setMessage(e.getMessage()), () -> TeamAppsCommunicationEndpoint.this.closeWebSocketSession(this.wsSession), null);
                }
                catch (Exception e) {
                    LOGGER.error("Exception while processing client message!", (Throwable)e);
                    this.send(this.wsSession, (AbstractServerMessage)new SERVER_ERROR(SERVER_ERROR.Reason.EXCEPTION).setMessage(e.getMessage()), null, null);
                }
            }
        }

        private void send(Session session, AbstractServerMessage message, Runnable sendingSuccessHandler, SendingErrorHandler sendingErrorHandler) {
            block6: {
                try {
                    String messageAsString;
                    try {
                        messageAsString = TeamAppsCommunicationEndpoint.this.mapper.writeValueAsString((Object)message);
                    }
                    catch (JsonProcessingException e) {
                        throw new TeamAppsCommunicationException(e);
                    }
                    byte[] uncompressed = messageAsString.getBytes(StandardCharsets.UTF_8);
                    if (this.deflater != null) {
                        byte[] compressed = this.deflater.deflate(uncompressed);
                        this.sendingZipRatioAnalyzer.addData(uncompressed, compressed.length);
                        this.sendBinaryFrame(session, compressed, sendingSuccessHandler, sendingErrorHandler);
                    } else {
                        LOGGER.warn("Trying to send data to already closed session!");
                    }
                }
                catch (RuntimeException e) {
                    if (sendingErrorHandler == null) break block6;
                    sendingErrorHandler.onErrorWhileSending((Throwable)e);
                }
            }
        }

        private ServerSideClientInfo createServerSideClientInfo(Session session) {
            Map attributes = session.getUserProperties();
            return new ServerSideClientInfo((String)attributes.get("CLIENT_IP"), (String)attributes.get("USER_AGENT"), (String)attributes.get("LANGUAGE"));
        }

        private void splitAndSend(Session session, byte[] bytesToSend, Runnable sendingSuccessHandler, SendingErrorHandler sendingErrorHandler) {
            int MAX_FRAME_SIZE = 65536;
            int usableFrameSize = MAX_FRAME_SIZE - 1;
            double numberOfFrames = Math.ceil((float)bytesToSend.length / (float)usableFrameSize);
            int i = 0;
            while ((double)i < numberOfFrames) {
                byte lastFrameOfMessageFlag;
                int frameSizeIncludingLastFrameOfMessageFlag = Math.min(bytesToSend.length - i * usableFrameSize + 1, MAX_FRAME_SIZE);
                byte[] frame = new byte[frameSizeIncludingLastFrameOfMessageFlag];
                frame[0] = lastFrameOfMessageFlag = (double)i == numberOfFrames - 1.0 ? (byte)1 : 0;
                System.arraycopy(bytesToSend, i * usableFrameSize, frame, 1, frame.length - 1);
                this.sendBinaryFrame(session, frame, sendingSuccessHandler, sendingErrorHandler);
                ++i;
            }
        }

        private void sendBinaryFrame(Session session, byte[] bytesToSend, final Runnable sendingSuccessHandler, final SendingErrorHandler sendingErrorHandler) {
            session.getAsyncRemote().sendBinary(ByteBuffer.wrap(bytesToSend), new SendHandler(){

                public void onResult(SendResult result) {
                    if (result.isOK() && sendingSuccessHandler != null) {
                        sendingSuccessHandler.run();
                    }
                    if (!result.isOK() && sendingErrorHandler != null) {
                        sendingErrorHandler.onErrorWhileSending(result.getException());
                    }
                }
            });
        }
    }
}

