/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.teamapps.dto.UiClientInfo;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.icons.provider.IconProvider;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.SessionRecorder;
import org.teamapps.server.SessionResourceProvider;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.ux.component.ClientObject;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.resource.ResourceProvider;
import org.teamapps.ux.resource.ResourceProviderServlet;
import org.teamapps.ux.resource.SystemIconResourceProvider;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class TeamAppsUxClientGate
implements UiSessionListener {
    private final WebController webController;
    private final UiCommandExecutor commandExecutor;
    private final ObjectMapper objectMapper;
    private Map<QualifiedUiSessionId, SessionContext> sessionContextById = new ConcurrentHashMap<QualifiedUiSessionId, SessionContext>();
    private Map<String, File> uploadedFilesByUuid = new ConcurrentHashMap<String, File>();
    private final UxServerContext uxServerContext = new UxServerContext(){

        public SessionContext getSessionContextById(QualifiedUiSessionId sessionId) {
            return (SessionContext)TeamAppsUxClientGate.this.sessionContextById.get(sessionId);
        }

        public File getUploadedFileByUuid(String uuid) {
            return (File)TeamAppsUxClientGate.this.uploadedFilesByUuid.get(uuid);
        }
    };
    private String userSessionCommandsRecordingPath;

    public TeamAppsUxClientGate(WebController webController, UiCommandExecutor commandExecutor, ObjectMapper objectMapper) {
        this.webController = webController;
        this.commandExecutor = commandExecutor;
        this.objectMapper = objectMapper;
    }

    public void onUiSessionStarted(QualifiedUiSessionId sessionId, UiClientInfo uiClientInfo) {
        SessionRecorder sessionRecorder = null;
        if (this.userSessionCommandsRecordingPath != null) {
            try {
                String timeStamp = new SimpleDateFormat("yyyy.MM.dd-HH.mm.ss").format(new Date());
                File outputFile = new File(this.userSessionCommandsRecordingPath, "Session-" + timeStamp + ".log");
                sessionRecorder = new SessionRecorder(this.objectMapper, (OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        ClientInfo clientInfo = new ClientInfo(uiClientInfo.getIp(), uiClientInfo.getScreenWidth(), uiClientInfo.getScreenHeight(), uiClientInfo.getViewPortWidth(), uiClientInfo.getViewPortHeight(), uiClientInfo.getPreferredLanguageIso(), uiClientInfo.getHighDensityScreen(), uiClientInfo.getTimezoneIana(), uiClientInfo.getTimezoneOffsetMinutes(), uiClientInfo.getClientTokens(), uiClientInfo.getUserAgentString(), uiClientInfo.getClientUrl(), uiClientInfo.getClientParameters());
        SessionContext context = new SessionContext(sessionId, clientInfo, this.commandExecutor, this.uxServerContext, this.webController.getDefaultIconTheme(clientInfo.isMobileDevice()), this.objectMapper);
        this.sessionContextById.put(sessionId, context);
        CompletableFuture future = context.runWithContext(() -> {
            context.setConfiguration(this.webController.createSessionConfiguration(context));
            context.registerTemplates(Arrays.stream(BaseTemplate.values()).collect(Collectors.toMap(Enum::name, BaseTemplate::getTemplate)));
            this.webController.onSessionStart(context);
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ServletRegistration> getServletRegistrations() {
        ArrayList<ServletRegistration> registrations = new ArrayList<ServletRegistration>();
        registrations.add(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)this.createSystemIconResourceProvider(this.webController.getIconProvider(), this.webController.getAdditionalIconProvider())), "/icons/*"));
        registrations.add(new ServletRegistration((Servlet)new ResourceProviderServlet((ResourceProvider)new SessionResourceProvider(this.sessionContextById::get)), "/files/*"));
        registrations.addAll(this.webController.getServletRegistrations(this.uxServerContext));
        return registrations;
    }

    private SystemIconResourceProvider createSystemIconResourceProvider(IconProvider iconProvider, List<IconProvider> customIconProvider) {
        try {
            File tempDir = File.createTempFile("temp", "temp").getParentFile();
            SystemIconResourceProvider systemIconProvider = new SystemIconResourceProvider(tempDir);
            systemIconProvider.registerStandardIconProvider(iconProvider);
            if (customIconProvider != null) {
                customIconProvider.forEach(provider -> systemIconProvider.registerCustomIconProvider(provider));
            }
            return systemIconProvider;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void onUiSessionClientRefresh(QualifiedUiSessionId sessionId, UiClientInfo clientInfo) {
        this.onUiSessionStarted(sessionId, clientInfo);
    }

    public void onActivityStateChanged(QualifiedUiSessionId sessionId, boolean active) {
        SessionContext context = this.sessionContextById.get(sessionId);
        if (context != null) {
            context.handleActivityStateChangedInternal(active);
        }
    }

    public void onUiSessionClosed(QualifiedUiSessionId sessionId, UiSessionClosingReason reason) {
        SessionContext context = this.sessionContextById.remove(sessionId);
        if (context != null) {
            context.handleSessionDestroyedInternal();
        }
    }

    public void onUiEvent(QualifiedUiSessionId sessionId, UiEvent event) {
        SessionContext sessionContext = this.sessionContextById.get(sessionId);
        if (sessionContext != null) {
            sessionContext.runWithContext(() -> {
                String uiComponentId = event.getComponentId();
                ClientObject clientObject = sessionContext.getClientObject(uiComponentId);
                if (clientObject != null) {
                    clientObject.handleUiEvent(event);
                }
            }).exceptionally(e -> {
                this.commandExecutor.closeSession(sessionId, UiSessionClosingReason.SERVER_SIDE_ERROR);
                return null;
            });
        }
    }

    public void handleFileUpload(File file, String uuid) {
        this.uploadedFilesByUuid.put(uuid, file);
    }

    public SessionContext getSessionContextById(QualifiedUiSessionId qualifiedUiSessionId) {
        return this.sessionContextById.get(qualifiedUiSessionId);
    }

    public String getUserSessionCommandsRecordingPath() {
        return this.userSessionCommandsRecordingPath;
    }

    public void setUserSessionCommandsRecordingPath(String userSessionCommandsRecordingPath) {
        this.userSessionCommandsRecordingPath = userSessionCommandsRecordingPath;
    }
}

