/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;

public class ZlibUtil {
    public static byte[] deflateString(String string) {
        return ZlibUtil.deflate(string.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] deflate(byte[] dataToCompress) {
        try {
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(dataToCompress.length / 3);
            try (DeflaterOutputStream deflateStream = new DeflaterOutputStream(byteOutStream);){
                deflateStream.write(dataToCompress);
            }
            return byteOutStream.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String inflateToString(byte[] input) {
        try {
            ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream(input.length * 5);
            try (InflaterOutputStream deflateStream = new InflaterOutputStream(byteOutStream);){
                deflateStream.write(input);
            }
            byte[] bytes = byteOutStream.toByteArray();
            return new String(bytes, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

