/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.dto.AbstractClientMessage;
import org.teamapps.dto.AbstractServerMessage;
import org.teamapps.dto.CMD_REQUEST;
import org.teamapps.dto.CMD_RESULT;
import org.teamapps.dto.EVENT;
import org.teamapps.dto.INIT;
import org.teamapps.dto.KEEPALIVE;
import org.teamapps.dto.REINIT;
import org.teamapps.dto.SESSION_CLOSED;
import org.teamapps.dto.TERMINATE;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.json.TeamAppsObjectMapperFactory;
import org.teamapps.uisession.MessageSender;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.SendingErrorHandler;
import org.teamapps.uisession.TeamAppsSessionNotFoundException;
import org.teamapps.uisession.TeamAppsUiSessionManager;
import org.teamapps.ux.servlet.ServerSideClientInfo;
import org.teamapps.ux.servlet.TeamAppsCommunicationException;

public class TeamAppsCommunicationEndpoint
extends Endpoint {
    private static final int MAX_BINARY_CLIENT_MESSAGE_SIZE = 0x100000;
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsCommunicationEndpoint.class);
    private final ObjectMapper mapper = TeamAppsObjectMapperFactory.create();
    private final TeamAppsUiSessionManager sessionManager;

    public TeamAppsCommunicationEndpoint(TeamAppsUiSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void onOpen(Session session, EndpointConfig config) {
        session.setMaxIdleTimeout(0x100000L);
        session.setMaxBinaryMessageBufferSize(0x100000);
        session.addMessageHandler((MessageHandler)new WebSocketHandler(session));
    }

    public void onError(Session session, Throwable thr) {
        this.closeWebSocketSession(session);
    }

    public void onClose(Session session, CloseReason closeReason) {
    }

    private void closeWebSocketSession(Session wsSession) {
        try {
            wsSession.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class WebSocketHandler
    implements MessageHandler.Whole<String> {
        private final Session wsSession;
        private boolean closed;

        public WebSocketHandler(Session session) {
            this.wsSession = session;
        }

        public void onMessage(String payload) {
            block10: {
                try {
                    HttpSession httpSession = (HttpSession)this.wsSession.getUserProperties().get("HTTP_SESSION");
                    AbstractClientMessage clientMessage = (AbstractClientMessage)TeamAppsCommunicationEndpoint.this.mapper.readValue(payload, AbstractClientMessage.class);
                    QualifiedUiSessionId qualifiedUiSessionId = new QualifiedUiSessionId(httpSession.getId(), clientMessage.getSessionId());
                    ServerSideClientInfo serverSideClientInfo = this.createServerSideClientInfo(this.wsSession);
                    if (clientMessage instanceof INIT) {
                        INIT init = (INIT)clientMessage;
                        init.getClientInfo().setIp(serverSideClientInfo.getIp());
                        init.getClientInfo().setUserAgentString(serverSideClientInfo.getUserAgentString());
                        init.getClientInfo().setPreferredLanguageIso(serverSideClientInfo.getPreferredLanguageIso());
                        TeamAppsCommunicationEndpoint.this.sessionManager.initSession(qualifiedUiSessionId, init.getClientInfo(), httpSession, init.getMaxRequestedCommandId(), (MessageSender)new MessageSenderImpl());
                        break block10;
                    }
                    if (clientMessage instanceof REINIT) {
                        REINIT reinit = (REINIT)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.reinitSession(qualifiedUiSessionId, reinit.getLastReceivedCommandId(), reinit.getMaxRequestedCommandId(), (MessageSender)new MessageSenderImpl());
                        break block10;
                    }
                    if (clientMessage instanceof TERMINATE) {
                        TeamAppsCommunicationEndpoint.this.sessionManager.closeSession(qualifiedUiSessionId, UiSessionClosingReason.TERMINATED_BY_CLIENT);
                        break block10;
                    }
                    if (clientMessage instanceof EVENT) {
                        EVENT eventMessage = (EVENT)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleEvent(qualifiedUiSessionId, eventMessage.getId(), eventMessage.getUiEvent());
                        break block10;
                    }
                    if (clientMessage instanceof CMD_RESULT) {
                        CMD_RESULT cmdResult = (CMD_RESULT)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleCommandResult(qualifiedUiSessionId, cmdResult.getId(), cmdResult.getCmdId(), cmdResult.getResult());
                        break block10;
                    }
                    if (clientMessage instanceof CMD_REQUEST) {
                        CMD_REQUEST cmdRequest = (CMD_REQUEST)clientMessage;
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleCommandRequest(qualifiedUiSessionId, cmdRequest.getLastReceivedCommandId(), cmdRequest.getMaxRequestedCommandId());
                        break block10;
                    }
                    if (clientMessage instanceof KEEPALIVE) {
                        TeamAppsCommunicationEndpoint.this.sessionManager.handleKeepAlive(qualifiedUiSessionId);
                        break block10;
                    }
                    throw new TeamAppsCommunicationException("Unknown message type: " + clientMessage.getClass().getCanonicalName());
                }
                catch (TeamAppsSessionNotFoundException e) {
                    LOGGER.warn("TeamApps session not found: " + e.getSessionId());
                    this.send(this.wsSession, (AbstractServerMessage)new SESSION_CLOSED(UiSessionClosingReason.SESSION_NOT_FOUND).setMessage(e.getMessage()), this::close, t -> this.close());
                }
                catch (Exception e) {
                    LOGGER.error("Exception while processing client message!", (Throwable)e);
                    this.send(this.wsSession, (AbstractServerMessage)new SESSION_CLOSED(UiSessionClosingReason.SERVER_SIDE_ERROR).setMessage(e.getMessage()), this::close, t -> this.close());
                }
            }
        }

        private void send(Session session, AbstractServerMessage message, final Runnable sendingSuccessHandler, final SendingErrorHandler sendingErrorHandler) {
            block5: {
                if (this.closed) {
                    sendingErrorHandler.onErrorWhileSending((Throwable)new TeamAppsCommunicationException("Connection closed!"));
                    return;
                }
                try {
                    String messageAsString;
                    try {
                        messageAsString = TeamAppsCommunicationEndpoint.this.mapper.writeValueAsString((Object)message);
                    }
                    catch (JsonProcessingException e) {
                        throw new TeamAppsCommunicationException(e);
                    }
                    session.getAsyncRemote().sendText(messageAsString, new SendHandler(){

                        public void onResult(SendResult result) {
                            if (result.isOK() && sendingSuccessHandler != null) {
                                sendingSuccessHandler.run();
                            }
                            if (!result.isOK() && sendingErrorHandler != null) {
                                sendingErrorHandler.onErrorWhileSending(result.getException());
                            }
                        }
                    });
                }
                catch (Exception e) {
                    if (sendingErrorHandler == null) break block5;
                    sendingErrorHandler.onErrorWhileSending((Throwable)e);
                }
            }
        }

        private ServerSideClientInfo createServerSideClientInfo(Session session) {
            Map attributes = session.getUserProperties();
            return new ServerSideClientInfo((String)attributes.get("CLIENT_IP"), (String)attributes.get("USER_AGENT"), (String)attributes.get("LANGUAGE"));
        }

        private void close() {
            this.closed = true;
            TeamAppsCommunicationEndpoint.this.closeWebSocketSession(this.wsSession);
        }

        private class MessageSenderImpl
        implements MessageSender {
            private MessageSenderImpl() {
            }

            public void sendMessageAsynchronously(AbstractServerMessage msg, SendingErrorHandler sendingErrorHandler) {
                WebSocketHandler.this.send(WebSocketHandler.this.wsSession, msg, null, sendingErrorHandler);
            }

            public void close(UiSessionClosingReason closingReason, String message) {
                WebSocketHandler.this.send(WebSocketHandler.this.wsSession, (AbstractServerMessage)new SESSION_CLOSED(closingReason).setMessage(message), () -> WebSocketHandler.this.close(), t -> WebSocketHandler.this.close());
            }
        }
    }
}

