/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig(location="/tmp", fileSizeThreshold=1000000, maxFileSize=-1L, maxRequestSize=-1L)
public class UploadServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadServlet.class);
    private String fileUploadTempDir = System.getProperty("java.io.tmpdir");
    private BiConsumer<File, String> uploadListener;

    public UploadServlet(BiConsumer<File, String> uploadListener) {
        this.uploadListener = uploadListener;
    }

    public void init() throws ServletException {
        super.init();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Collection parts = request.getParts();
        ArrayList<String> uuids = new ArrayList<String>();
        try {
            for (Part file : parts) {
                String uuidString = UUID.randomUUID().toString();
                File tempFile = new File(this.fileUploadTempDir, uuidString);
                try (InputStream in = file.getInputStream();
                     FileOutputStream out = new FileOutputStream(tempFile);){
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                uuids.add(uuidString);
                this.uploadListener.accept(tempFile, uuidString);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while uploading files" + e);
            response.setStatus(500);
            return;
        }
        response.setStatus(200);
        response.setContentType("application/json");
        response.getWriter().println("[" + uuids.stream().map(uuid -> "\"" + uuid + "\"").collect(Collectors.joining(",")) + "]");
    }
}

