/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.teamapps.ux.session.SimpleSessionContext;

public interface ApplicationResourceBundleInfo {
    public static ApplicationResourceBundleInfo createUTF8PropertyBundlesInfo(String baseName, Locale baseLocale, Locale ... availableTranslations) {
        return ApplicationResourceBundleInfo.createUTF8PropertyBundlesInfo(baseName, "properties", baseLocale, availableTranslations);
    }

    public static ApplicationResourceBundleInfo createUTF8PropertyBundlesInfo(String baseName, String suffix, Locale baseLocale, Locale ... availableTranslations) {
        Function<Locale, ResourceBundle> resourceBundleByLocaleFunction = locale -> ResourceBundle.getBundle(baseName, locale, new SimpleSessionContext.UTF8Control(suffix));
        return ApplicationResourceBundleInfo.createInfo(resourceBundleByLocaleFunction, baseLocale, availableTranslations);
    }

    public static ApplicationResourceBundleInfo createInfo(final Function<Locale, ResourceBundle> resourceBundleByLocaleFunction, final Locale baseLocale, final Locale ... availableTranslations) {
        return new ApplicationResourceBundleInfo(){

            @Override
            public Function<Locale, ResourceBundle> getResourceBundleByLocaleFunction() {
                return resourceBundleByLocaleFunction;
            }

            @Override
            public Locale getBaseLocale() {
                return baseLocale;
            }

            @Override
            public List<Locale> getAvailableTranslations() {
                if (availableTranslations == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(availableTranslations);
            }
        };
    }

    public Function<Locale, ResourceBundle> getResourceBundleByLocaleFunction();

    public Locale getBaseLocale();

    public List<Locale> getAvailableTranslations();
}

