/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import org.teamapps.icons.api.Icon;
import org.teamapps.server.ServletRegistration;
import org.teamapps.server.UxServerContext;
import org.teamapps.ux.application.ManagedResourceBundleProvider;
import org.teamapps.ux.application.ResponsiveApplicationBuilder;
import org.teamapps.ux.application.ResponsiveApplicationGroup;
import org.teamapps.ux.application.RootWindowHandler;
import org.teamapps.ux.application.view.View;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.login.LoginAuthenticator;
import org.teamapps.ux.resource.ClassPathResourceProvider;
import org.teamapps.ux.resource.ResourceProviderServlet;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class ResponsiveApplicationController
implements WebController,
ManagedResourceBundleProvider,
RootWindowHandler {
    private View applicationLauncher;
    private List<ResponsiveApplicationGroup> applicationGroups = new ArrayList<ResponsiveApplicationGroup>();
    private LoginAuthenticator authenticator;
    private List<ServletRegistration> servletRegistrations = new ArrayList<ServletRegistration>();
    private List<Function<UxServerContext, ServletRegistration>> servletRegistrationFactories = new ArrayList<Function<UxServerContext, ServletRegistration>>();
    private String loginBackground = "/resources/backgrounds/login3.jpg";
    private String loginBackgroundBlurred = "/resources/backgrounds/login3-bl.jpg";
    private String defaultBackground = "/resources/default-bl.jpg";

    @Override
    public void onSessionStart(SessionContext context) {
    }

    public void addClassPathResourceProvider(String basePackage, String prefix) {
        if (!((String)prefix).endsWith("/")) {
            prefix = (String)prefix + "/";
        }
        this.addServletRegistration(new ServletRegistration((Servlet)new ResourceProviderServlet(new ClassPathResourceProvider(basePackage)), (String)prefix + "*"));
    }

    @Override
    public Collection<ServletRegistration> getServletRegistrations(UxServerContext serverContext) {
        ArrayList<ServletRegistration> registrations = new ArrayList<ServletRegistration>();
        registrations.addAll(this.servletRegistrations);
        registrations.addAll(this.servletRegistrationFactories.stream().map(f -> (ServletRegistration)f.apply(serverContext)).collect(Collectors.toList()));
        return registrations;
    }

    public ResponsiveApplicationGroup addApplicationGroup(Icon icon, String title) {
        ResponsiveApplicationGroup applicationGroup = new ResponsiveApplicationGroup(this.applicationLauncher, this, this);
        this.applicationGroups.add(applicationGroup);
        return applicationGroup;
    }

    @Override
    public void registerApplicationResourceBundle(ResponsiveApplicationBuilder applicationBuilder) {
    }

    @Override
    public ResourceBundle getManagedResourceBundle(ResponsiveApplicationBuilder applicationBuilder, Locale locale) {
        return null;
    }

    @Override
    public void showTopLevelComponent(ResponsiveApplicationBuilder applicationBuilder, Icon icon, String title, Component component) {
    }

    @Override
    public void removeTopLevelComponent(ResponsiveApplicationBuilder applicationBuilder, Component component) {
    }

    @Override
    public String createCustomApplicationEntryURL(ResponsiveApplicationBuilder applicationBuilder, boolean authenticateUser, boolean loadApplicationLauncher, Map<String, String> parameterMap) {
        return null;
    }

    @Override
    public String createCustomApplicationEntryURL(ResponsiveApplicationBuilder applicationBuilder, boolean authenticateUser, boolean loadApplicationLauncher, TimeUnit validityTimeUnit, long validityDuration, Map<String, String> parameterMap) {
        return null;
    }

    public void addServletRegistration(ServletRegistration servletRegistration) {
        this.servletRegistrations.add(servletRegistration);
    }

    public void addServletRegistrationFactory(Function<UxServerContext, ServletRegistration> servletRegistrationFactory) {
        this.servletRegistrationFactories.add(servletRegistrationFactory);
    }
}

