/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.documentviewer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiDocumentViewer;
import org.teamapps.dto.UiEvent;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.documentviewer.PageDisplayMode;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.Shadow;

public class DocumentViewer
extends AbstractComponent {
    private List<String> pageUrls = new ArrayList<String>();
    private PageDisplayMode displayMode = PageDisplayMode.FIT_WIDTH;
    private float zoomFactor = 1.0f;
    private Border pageBorder;
    private Shadow pageShadow;
    private int padding;
    private int pageSpacing = 5;

    public DocumentViewer() {
    }

    public DocumentViewer(List<String> pageUrls) {
        this.pageUrls.addAll(pageUrls);
    }

    @Override
    public UiComponent createUiComponent() {
        UiDocumentViewer documentViewer = new UiDocumentViewer(this.getId());
        this.mapAbstractUiComponentProperties((UiComponent)documentViewer);
        documentViewer.setPageUrls(this.pageUrls);
        documentViewer.setDisplayMode(this.displayMode.toUiPageDisplayMode());
        documentViewer.setZoomFactor(this.zoomFactor);
        documentViewer.setPageBorder(this.pageBorder != null ? this.pageBorder.createUiBorder() : null);
        documentViewer.setPageShadow(this.pageShadow != null ? this.pageShadow.createUiShadow() : null);
        documentViewer.setPadding(this.padding);
        documentViewer.setPageSpacing(this.pageSpacing);
        return documentViewer;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
    }

    public List<String> getPageUrls() {
        return this.pageUrls;
    }

    public void setPageUrls(List<String> pageUrls) {
        this.pageUrls.clear();
        this.pageUrls.addAll(pageUrls);
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetPageUrlsCommand(this.getId(), this.pageUrls));
    }

    public void setPageUrls(String ... pageUrls) {
        this.setPageUrls(Arrays.asList(pageUrls));
    }

    public void addPageUrl(String pageUrl) {
        this.pageUrls.add(pageUrl);
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetPageUrlsCommand(this.getId(), this.pageUrls));
    }

    public PageDisplayMode getDisplayMode() {
        return this.displayMode;
    }

    public void setDisplayMode(PageDisplayMode displayMode) {
        this.displayMode = displayMode;
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetDisplayModeCommand(this.getId(), displayMode.toUiPageDisplayMode(), this.zoomFactor));
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public void setZoomFactor(float zoomFactor) {
        this.zoomFactor = zoomFactor;
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetZoomFactorCommand(this.getId(), zoomFactor));
    }

    public Border getPageBorder() {
        return this.pageBorder;
    }

    public void setPageBorder(Border pageBorder) {
        this.pageBorder = pageBorder;
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetPageBorderCommand(this.getId(), pageBorder != null ? pageBorder.createUiBorder() : null));
    }

    public Shadow getPageShadow() {
        return this.pageShadow;
    }

    public void setPageShadow(Shadow pageShadow) {
        this.pageShadow = pageShadow;
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetPageShadowCommand(this.getId(), pageShadow != null ? pageShadow.createUiShadow() : null));
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetPadddingCommand(this.getId(), padding));
    }

    public int getPageSpacing() {
        return this.pageSpacing;
    }

    public void setPageSpacing(int pageSpacing) {
        this.pageSpacing = pageSpacing;
        this.queueCommandIfRendered(() -> new UiDocumentViewer.SetPageSpacingCommand(this.getId(), pageSpacing));
    }

    @Override
    protected void doDestroy() {
    }
}

