/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form;

import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.form.ResponsiveFormSection;
import org.teamapps.ux.component.form.layoutpolicy.FormSectionFieldPlacement;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.grid.layout.GridColumn;
import org.teamapps.ux.component.grid.layout.GridRow;

public class ResponsiveFormField {
    private final ResponsiveFormSection responsiveFormSection;
    private final AbstractField field;
    private final int row;
    private final int column;
    private int rowSpan;
    private int colSpan;
    private int minWidth;
    private int maxWidth;
    private int minHeight;
    private int maxHeight;
    private VerticalElementAlignment verticalAlignment = VerticalElementAlignment.CENTER;
    private HorizontalElementAlignment horizontalAlignment = HorizontalElementAlignment.LEFT;

    protected ResponsiveFormField(ResponsiveFormSection responsiveFormSection, AbstractField field, int row, int column, FormSectionFieldPlacement fieldPlacementTemplate) {
        this.responsiveFormSection = responsiveFormSection;
        this.field = field;
        this.row = row;
        this.column = column;
        if (fieldPlacementTemplate != null) {
            this.rowSpan = fieldPlacementTemplate.getRowSpan();
            this.colSpan = fieldPlacementTemplate.getColSpan();
            this.minWidth = fieldPlacementTemplate.getMinWidth();
            this.maxWidth = fieldPlacementTemplate.getMaxWidth();
            this.minHeight = fieldPlacementTemplate.getMinHeight();
            this.maxHeight = fieldPlacementTemplate.getMaxHeight();
            this.verticalAlignment = fieldPlacementTemplate.getVerticalAlignment();
            this.horizontalAlignment = fieldPlacementTemplate.getHorizontalAlignment();
        }
    }

    protected FormSectionFieldPlacement createFormSectionPlacement() {
        FormSectionFieldPlacement<AbstractField> placement = new FormSectionFieldPlacement<AbstractField>(this.field, this.row, this.column);
        placement.setRowSpan(this.rowSpan);
        placement.setColSpan(this.colSpan);
        placement.setMinWidth(this.minWidth);
        placement.setMaxWidth(this.maxWidth);
        placement.setMinHeight(this.minHeight);
        placement.setMaxHeight(this.maxHeight);
        placement.setVerticalAlignment(this.verticalAlignment);
        placement.setHorizontalAlignment(this.horizontalAlignment);
        return placement;
    }

    public GridRow getRowDefinition() {
        return this.responsiveFormSection.getRow(this.row);
    }

    public GridColumn getColumnDefinition() {
        return this.responsiveFormSection.getColumn(this.column);
    }

    public ResponsiveFormSection getResponsiveFormSection() {
        return this.responsiveFormSection;
    }

    public AbstractField getField() {
        return this.field;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    public ResponsiveFormField setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public ResponsiveFormField setColSpan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public ResponsiveFormField setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public ResponsiveFormField setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public ResponsiveFormField setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public ResponsiveFormField setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public VerticalElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public ResponsiveFormField setVerticalAlignment(VerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public HorizontalElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public ResponsiveFormField setHorizontalAlignment(HorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }
}

