/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.tabpanel;

import java.util.UUID;
import org.teamapps.dto.UiTab;
import org.teamapps.event.Event;
import org.teamapps.icons.api.Icon;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.tabpanel.TabPanel;
import org.teamapps.ux.component.toolbar.Toolbar;
import org.teamapps.ux.session.CurrentSessionContext;
import org.teamapps.ux.session.SessionContext;

public class Tab {
    public final Event<Void> onSelected = new Event();
    public final Event<Void> onDeselected = new Event();
    public final Event<Void> onClosed = new Event();
    private final String clientId = UUID.randomUUID().toString();
    private TabPanel tabPanel;
    private Icon icon;
    private String title;
    private boolean closeable;
    private boolean lazyLoading;
    private boolean rightSide;
    private boolean visible = true;
    private Component content;
    private Toolbar toolbar;

    public Tab() {
        this(null, null, null, false);
    }

    public Tab(Icon icon, String title, Component content) {
        this(icon, title, content, false);
    }

    public Tab(Icon icon, String title, Component content, boolean lazyLoading) {
        this.title = title;
        this.icon = icon;
        this.content = content;
        this.lazyLoading = lazyLoading;
    }

    public UiTab createUiTab() {
        SessionContext context = CurrentSessionContext.get();
        UiTab uiTab = new UiTab(this.clientId, context.resolveIcon(this.icon), this.title);
        uiTab.setCloseable(this.closeable);
        uiTab.setLazyLoading(this.isLazyLoading());
        uiTab.setRightSide(this.rightSide);
        uiTab.setToolbar(Component.createUiComponentReference(this.toolbar));
        uiTab.setContent(Component.createUiComponentReference(this.content));
        uiTab.setVisible(this.visible);
        return uiTab;
    }

    void setTabPanel(TabPanel tabPanel) {
        this.tabPanel = tabPanel;
    }

    public void select() {
        this.tabPanel.handleTabSelected(this);
    }

    String getClientId() {
        return this.clientId;
    }

    public String getTitle() {
        return this.title;
    }

    public Tab setTitle(String title) {
        this.title = title;
        if (this.tabPanel != null) {
            this.tabPanel.handleTabConfigurationChanged(this);
        }
        return this;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Tab setIcon(Icon icon) {
        this.icon = icon;
        if (this.tabPanel != null) {
            this.tabPanel.handleTabConfigurationChanged(this);
        }
        return this;
    }

    public Component getContent() {
        return this.content;
    }

    public Tab setContent(Component content) {
        this.content = content;
        if (content != null) {
            content.setParent(this.tabPanel);
        }
        if (this.tabPanel != null) {
            this.tabPanel.handleTabContentChanged(this);
        }
        return this;
    }

    public boolean isRightSide() {
        return this.rightSide;
    }

    public Tab setRightSide(boolean rightSide) {
        this.rightSide = rightSide;
        if (this.tabPanel != null) {
            this.tabPanel.handleTabConfigurationChanged(this);
        }
        return this;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public Tab setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
        return this;
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public Tab setCloseable(boolean closeable) {
        this.closeable = closeable;
        if (this.tabPanel != null) {
            this.tabPanel.handleTabConfigurationChanged(this);
        }
        return this;
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    public Tab setToolbar(Toolbar toolbar) {
        this.toolbar = toolbar;
        if (toolbar != null) {
            this.tabPanel.handleTabToolbarChanged(this);
        }
        return this;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Tab setVisible(boolean visible) {
        this.visible = visible;
        if (this.tabPanel != null) {
            this.tabPanel.handleTabVisibilityChanged(this);
        }
        return this;
    }

    public void destroy() {
        if (this.content != null) {
            this.content.destroy();
        }
        if (this.toolbar != null) {
            this.toolbar.destroy();
        }
    }
}

