/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph.partitioning;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public enum TimePartitionUnit {
    MILLISECOND(1L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(1L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(1L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_2(2L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 2L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(2L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(2L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_5(5L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 5L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(5L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(5L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_10(10L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 10L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(10L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(10L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_20(20L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 20L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(20L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(20L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_50(50L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 50L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(50L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(50L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_100(100L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 100L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(100L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(100L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_200(200L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 200L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(200L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(200L, ChronoUnit.MILLIS);
        }
    }
    ,
    MILLISECOND_500(500L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            long epochMilli = zonedDateTime.toInstant().toEpochMilli();
            epochMilli -= epochMilli % 500L;
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plus(500L, ChronoUnit.MILLIS);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minus(500L, ChronoUnit.MILLIS);
        }
    }
    ,
    SECOND(1000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.SECONDS);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusSeconds(1L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusSeconds(1L);
        }
    }
    ,
    SECONDS_2(2000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.SECONDS).withSecond(2 * (zonedDateTime.getSecond() / 2));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusSeconds(2L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusSeconds(2L);
        }
    }
    ,
    SECONDS_5(5000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.SECONDS).withSecond(5 * (zonedDateTime.getSecond() / 5));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusSeconds(5L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusSeconds(5L);
        }
    }
    ,
    SECONDS_10(10000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.SECONDS).withSecond(10 * (zonedDateTime.getSecond() / 10));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusSeconds(10L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusSeconds(10L);
        }
    }
    ,
    SECONDS_15(15000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.SECONDS).withSecond(15 * (zonedDateTime.getSecond() / 15));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusSeconds(15L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusSeconds(15L);
        }
    }
    ,
    SECONDS_30(30000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.SECONDS).withSecond(30 * (zonedDateTime.getSecond() / 30));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusSeconds(30L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusSeconds(30L);
        }
    }
    ,
    MINUTE(60000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.MINUTES);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMinutes(1L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMinutes(1L);
        }
    }
    ,
    MINUTES_2(120000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.MINUTES).withMinute(2 * (zonedDateTime.getMinute() / 2));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMinutes(2L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMinutes(2L);
        }
    }
    ,
    MINUTES_5(300000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.MINUTES).withMinute(5 * (zonedDateTime.getMinute() / 5));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMinutes(5L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMinutes(5L);
        }
    }
    ,
    MINUTES_10(600000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.MINUTES).withMinute(10 * (zonedDateTime.getMinute() / 10));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMinutes(10L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMinutes(10L);
        }
    }
    ,
    MINUTES_15(900000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.MINUTES).withMinute(15 * (zonedDateTime.getMinute() / 15));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMinutes(15L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMinutes(15L);
        }
    }
    ,
    MINUTES_30(1800000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.MINUTES).withMinute(30 * (zonedDateTime.getMinute() / 30));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMinutes(30L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMinutes(30L);
        }
    }
    ,
    HOUR(3600000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.HOURS);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusHours(1L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusHours(1L);
        }
    }
    ,
    HOURS_6(21600000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.HOURS).withHour(6 * (zonedDateTime.getHour() / 6));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            if (zonedDateTime.getHour() == 0) {
                return zonedDateTime.withHour(6);
            }
            if (zonedDateTime.getHour() == 6) {
                return zonedDateTime.withHour(12);
            }
            if (zonedDateTime.getHour() == 12) {
                return zonedDateTime.withHour(18);
            }
            if (zonedDateTime.getHour() == 18) {
                return zonedDateTime.plusDays(1L).withHour(0);
            }
            return zonedDateTime.plusHours(6L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            if (zonedDateTime.getHour() == 0) {
                return zonedDateTime.minusDays(1L).withHour(18);
            }
            if (zonedDateTime.getHour() == 6) {
                return zonedDateTime.withHour(0);
            }
            if (zonedDateTime.getHour() == 12) {
                return zonedDateTime.withHour(6);
            }
            if (zonedDateTime.getHour() == 18) {
                return zonedDateTime.withHour(12);
            }
            return zonedDateTime.minusHours(6L);
        }
    }
    ,
    HOURS_12(43200000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.HOURS).withHour(12 * (zonedDateTime.getHour() / 12));
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            if (zonedDateTime.getHour() == 0) {
                return zonedDateTime.withHour(12);
            }
            if (zonedDateTime.getHour() == 12) {
                return zonedDateTime.plusDays(1L).withHour(0);
            }
            return zonedDateTime.plusHours(12L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            if (zonedDateTime.getHour() == 0) {
                return zonedDateTime.minusDays(1L).withHour(12);
            }
            if (zonedDateTime.getHour() == 12) {
                return zonedDateTime.withHour(0);
            }
            return zonedDateTime.minusHours(12L);
        }
    }
    ,
    DAY(86400000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.DAYS);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusDays(1L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusDays(1L);
        }
    }
    ,
    WEEK_SUNDAY(604800000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            int dayOfWeek = (zonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS)).getDayOfWeek().getValue();
            if (dayOfWeek < DayOfWeek.SUNDAY.getValue()) {
                zonedDateTime = zonedDateTime.minusDays(dayOfWeek);
            }
            return zonedDateTime;
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusDays(7L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusDays(7L);
        }
    }
    ,
    WEEK_MONDAY(604800000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            zonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS);
            zonedDateTime = zonedDateTime.minusDays(zonedDateTime.getDayOfWeek().ordinal());
            return zonedDateTime;
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusDays(7L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusDays(7L);
        }
    }
    ,
    MONTH(2592000000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return zonedDateTime.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMonths(1L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMonths(1L);
        }
    }
    ,
    QUARTER(7776000000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            zonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
            return zonedDateTime.withMonth(3 * ((zonedDateTime.getMonthValue() - 1) / 3) + 1);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMonths(3L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMonths(3L);
        }
    }
    ,
    HALF_YEAR(15552000000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            zonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS).withDayOfMonth(1);
            return zonedDateTime.withMonth(6 * ((zonedDateTime.getMonthValue() - 1) / 6) + 1);
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusMonths(6L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusMonths(6L);
        }
    }
    ,
    YEAR(31104000000L){

        @Override
        public ZonedDateTime getPartition(ZonedDateTime zonedDateTime) {
            return ZonedDateTime.of(zonedDateTime.getYear(), 1, 1, 0, 0, 0, 0, zonedDateTime.getZone());
        }

        @Override
        public ZonedDateTime increment(ZonedDateTime zonedDateTime) {
            return zonedDateTime.plusYears(1L);
        }

        @Override
        public ZonedDateTime decrement(ZonedDateTime zonedDateTime) {
            return zonedDateTime.minusYears(1L);
        }
    };

    private final long averageMilliseconds;

    private TimePartitionUnit(long averageMilliseconds) {
        this.averageMilliseconds = averageMilliseconds;
    }

    public long getAverageMilliseconds() {
        return this.averageMilliseconds;
    }

    public abstract ZonedDateTime getPartition(ZonedDateTime var1);

    public abstract ZonedDateTime increment(ZonedDateTime var1);

    public abstract ZonedDateTime decrement(ZonedDateTime var1);
}

