/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.tree;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.dto.UiComboBoxTreeRecord;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiTree;
import org.teamapps.dto.UiTreeRecord;
import org.teamapps.event.Event;
import org.teamapps.event.EventListener;
import org.teamapps.ux.cache.CacheManipulationHandle;
import org.teamapps.ux.cache.ClientRecordCache;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.TextMatchingMode;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.node.TreeNode;
import org.teamapps.ux.component.template.Template;
import org.teamapps.ux.component.tree.TreeNodeInfo;
import org.teamapps.ux.component.tree.TreeNodeInfoExtractor;
import org.teamapps.ux.model.TreeModel;
import org.teamapps.ux.model.TreeModelChangedEventData;

public class Tree<RECORD>
extends AbstractComponent {
    private final Logger LOGGER = LoggerFactory.getLogger(Tree.class);
    public final Event<RECORD> onNodeSelected = new Event();
    public final Event<String> onTextInput = new Event();
    private TreeModel<RECORD> model;
    private final ClientRecordCache<RECORD, UiTreeRecord> recordCache = new ClientRecordCache<Object, UiTreeRecord>(this::createUiTreeRecordWithoutParentRelation, this::addParentLinkToUiRecord);
    private TextMatchingMode textMatchingMode = TextMatchingMode.CONTAINS;
    private PropertyExtractor<RECORD> propertyExtractor = new BeanPropertyExtractor();
    private RECORD selectedNode;
    private Template entryTemplate = null;
    private TemplateDecider<RECORD> templateDecider = record -> this.entryTemplate;
    private final Map<Template, String> templateIdsByTemplate = new HashMap<Template, String>();
    private int templateIdCounter = 0;
    private int indentation = 15;
    private boolean animate = true;
    private boolean showExpanders = true;
    private boolean openOnSelection = false;
    private boolean enforceSingleExpandedPath = false;
    private Function<RECORD, String> recordToStringFunction = Object::toString;
    private TreeNodeInfoExtractor<RECORD> treeNodeInfoExtractor = record -> {
        if (record instanceof TreeNode) {
            return (TreeNode)record;
        }
        return null;
    };
    private final EventListener<List<RECORD>> modelAllNodesChangedListener = dataRecords -> {
        if (this.isRendered()) {
            CacheManipulationHandle<List<UiTreeRecord>> cacheResponse = this.recordCache.replaceRecords((List<RECORD>)dataRecords);
            this.getSessionContext().queueCommand(new UiTree.ReplaceDataCommand(this.getId(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
        }
    };
    private final EventListener<TreeModelChangedEventData<RECORD>> modelChangedListener = changedEventData -> {
        List nodesRemoved = changedEventData.getNodesRemoved();
        List nodesAdded = changedEventData.getNodesAddedOrUpdated();
        if (this.isRendered()) {
            CacheManipulationHandle<List<Integer>> cacheRemoveResponse = this.recordCache.removeRecords(nodesRemoved);
            CacheManipulationHandle<List<UiTreeRecord>> cacheAddResponse = this.recordCache.addRecords(nodesAdded);
            this.getSessionContext().queueCommand(new UiTree.BulkUpdateCommand(this.getId(), cacheRemoveResponse.getResult(), cacheAddResponse.getResult()), aVoid -> {
                cacheRemoveResponse.commit();
                cacheAddResponse.commit();
            });
        }
    };

    public Tree(TreeModel<RECORD> model) {
        this.model = model;
        this.registerModelListeners();
    }

    private void registerModelListeners() {
        this.model.onAllNodesChanged().addListener(this.modelAllNodesChangedListener);
        this.model.onChanged().addListener(this.modelChangedListener);
    }

    private void unregisterMutableTreeModelListeners() {
        this.model.onAllNodesChanged().removeListener(this.modelAllNodesChangedListener);
        this.model.onChanged().removeListener(this.modelChangedListener);
    }

    @Override
    protected void doDestroy() {
        this.unregisterMutableTreeModelListeners();
    }

    protected UiTreeRecord createUiTreeRecordWithoutParentRelation(RECORD record) {
        if (record == null) {
            return null;
        }
        Template template = this.getTemplateForRecord(record);
        List<String> dataKeys = template != null ? template.getDataKeys() : Collections.emptyList();
        Map<String, Object> values = this.propertyExtractor.getValues(record, dataKeys);
        UiComboBoxTreeRecord uiTreeRecord = new UiComboBoxTreeRecord();
        uiTreeRecord.setValues(values);
        uiTreeRecord.setDisplayTemplateId(this.templateIdsByTemplate.get(template));
        uiTreeRecord.setAsString(this.recordToStringFunction.apply(record));
        TreeNodeInfo treeNodeInfo = this.treeNodeInfoExtractor.getTreeNodeInfo(record);
        if (treeNodeInfo != null) {
            uiTreeRecord.setExpanded(treeNodeInfo.isExpanded());
            uiTreeRecord.setLazyChildren(treeNodeInfo.isLazyChildren());
        }
        return uiTreeRecord;
    }

    protected void addParentLinkToUiRecord(RECORD record, UiTreeRecord uiTreeRecord, Map<RECORD, UiTreeRecord> othersCurrentlyBeingAddedToCache) {
        Object parent;
        TreeNodeInfo treeNodeInfo = this.treeNodeInfoExtractor.getTreeNodeInfo(record);
        if (treeNodeInfo != null && (parent = treeNodeInfo.getParent()) != null) {
            UiTreeRecord uiParentFromOthers = othersCurrentlyBeingAddedToCache.get(parent);
            if (uiParentFromOthers != null) {
                uiTreeRecord.setParentId(Integer.valueOf(uiParentFromOthers.getId()));
            } else {
                Integer cachedParentUiRecordId = this.recordCache.getUiRecordIdOrNull(parent);
                if (cachedParentUiRecordId != null) {
                    uiTreeRecord.setParentId(cachedParentUiRecordId);
                }
            }
        }
    }

    private Template getTemplateForRecord(RECORD record) {
        Template template;
        Template templateFromDecider = this.templateDecider.getTemplate(record);
        Template template2 = template = templateFromDecider != null ? templateFromDecider : this.entryTemplate;
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            String uuid = "" + this.templateIdCounter++;
            this.templateIdsByTemplate.put(template, uuid);
            this.queueCommandIfRendered(() -> new UiTree.RegisterTemplateCommand(this.getId(), uuid, template.createUiTemplate()));
        }
        return template;
    }

    @Override
    public UiComponent createUiComponent() {
        UiTree uiTree = new UiTree(this.getId());
        this.mapAbstractUiComponentProperties((UiComponent)uiTree);
        List records = this.model.getRecords(null);
        if (records != null) {
            CacheManipulationHandle<List<UiTreeRecord>> cacheResponse = this.recordCache.replaceRecords(records);
            cacheResponse.commit();
            uiTree.setInitialData(cacheResponse.getResult());
        }
        uiTree.setSelectedNodeId(this.recordCache.getUiRecordIdOrNull(this.selectedNode));
        uiTree.setTemplates(this.templateIdsByTemplate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((Template)entry.getKey()).createUiTemplate())));
        uiTree.setDefaultTemplateId(this.templateIdsByTemplate.get(this.entryTemplate));
        uiTree.setAnimate(this.animate);
        uiTree.setShowExpanders(this.showExpanders);
        uiTree.setOpenOnSelection(this.openOnSelection);
        uiTree.setEnforceSingleExpandedPath(this.enforceSingleExpandedPath);
        uiTree.setTextMatchingMode(this.textMatchingMode.toUiTextMatchingMode());
        uiTree.setIndentation(this.indentation);
        return uiTree;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_TREE_NODE_SELECTED: {
                UiTree.NodeSelectedEvent nodeSelectedEvent = (UiTree.NodeSelectedEvent)event;
                RECORD record = this.recordCache.getRecordByClientId(nodeSelectedEvent.getNodeId());
                this.onNodeSelected.fire(record);
                break;
            }
            case UI_TREE_REQUEST_TREE_DATA: {
                UiTree.RequestTreeDataEvent requestTreeDataEvent = (UiTree.RequestTreeDataEvent)event;
                RECORD parentNode = this.recordCache.getRecordByClientId(requestTreeDataEvent.getParentNodeId());
                if (parentNode == null) break;
                List<RECORD> children = this.model.getChildRecords(parentNode);
                CacheManipulationHandle<List<UiTreeRecord>> cacheResponse = this.recordCache.addRecords(children);
                if (this.isRendered()) {
                    this.getSessionContext().queueCommand(new UiTree.BulkUpdateCommand(this.getId(), Collections.emptyList(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
                    break;
                }
                cacheResponse.commit();
                break;
            }
            case UI_TREE_TEXT_INPUT: {
                UiTree.TextInputEvent textInputEvent = (UiTree.TextInputEvent)event;
                if (this.model != null) {
                    List records = this.model.getRecords(textInputEvent.getText());
                    CacheManipulationHandle<List<UiTreeRecord>> cacheResponse = this.recordCache.replaceRecords(records);
                    if (this.isRendered()) {
                        this.getSessionContext().queueCommand(new UiTree.ReplaceDataCommand(this.getId(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
                    } else {
                        cacheResponse.commit();
                    }
                }
                this.onTextInput.fire(textInputEvent.getText());
            }
        }
    }

    public RECORD getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(RECORD selectedNode) {
        Integer uiRecord = this.recordCache.getUiRecordIdOrNull(selectedNode);
        this.selectedNode = selectedNode;
        this.queueCommandIfRendered(() -> new UiTree.SetSelectedNodeCommand(this.getId(), uiRecord));
    }

    public TreeModel<RECORD> getModel() {
        return this.model;
    }

    public void setModel(TreeModel<RECORD> model) {
        this.unregisterMutableTreeModelListeners();
        this.model = model;
        this.registerModelListeners();
        this.refresh();
    }

    private void refresh() {
        if (this.isRendered()) {
            List records = this.model.getRecords(null);
            CacheManipulationHandle<List<UiTreeRecord>> cacheResponse = this.recordCache.replaceRecords(records);
            this.getSessionContext().queueCommand(new UiTree.ReplaceDataCommand(this.getId(), cacheResponse.getResult()), aVoid -> cacheResponse.commit());
        }
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
        this.reRenderIfRendered();
    }

    public boolean isShowExpanders() {
        return this.showExpanders;
    }

    public void setShowExpanders(boolean showExpanders) {
        this.showExpanders = showExpanders;
        this.reRenderIfRendered();
    }

    public boolean isOpenOnSelection() {
        return this.openOnSelection;
    }

    public void setOpenOnSelection(boolean openOnSelection) {
        this.openOnSelection = openOnSelection;
        this.reRenderIfRendered();
    }

    public boolean isEnforceSingleExpandedPath() {
        return this.enforceSingleExpandedPath;
    }

    public void setEnforceSingleExpandedPath(boolean enforceSingleExpandedPath) {
        this.enforceSingleExpandedPath = enforceSingleExpandedPath;
        this.reRenderIfRendered();
    }

    public TextMatchingMode getTextMatchingMode() {
        return this.textMatchingMode;
    }

    public void setTextMatchingMode(TextMatchingMode textMatchingMode) {
        this.textMatchingMode = textMatchingMode;
        this.reRenderIfRendered();
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int indentation) {
        this.indentation = indentation;
        this.reRenderIfRendered();
    }

    public PropertyExtractor<RECORD> getPropertyExtractor() {
        return this.propertyExtractor;
    }

    public void setPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.propertyExtractor = propertyExtractor;
    }

    public Template getEntryTemplate() {
        return this.entryTemplate;
    }

    public void setEntryTemplate(Template entryTemplate) {
        this.entryTemplate = entryTemplate;
        this.reRenderIfRendered();
    }

    public TemplateDecider<RECORD> getTemplateDecider() {
        return this.templateDecider;
    }

    public void setTemplateDecider(TemplateDecider<RECORD> templateDecider) {
        this.templateDecider = templateDecider;
        this.reRenderIfRendered();
    }

    public Function<RECORD, String> getRecordToStringFunction() {
        return this.recordToStringFunction;
    }

    public void setRecordToStringFunction(Function<RECORD, String> recordToStringFunction) {
        this.recordToStringFunction = recordToStringFunction;
        this.reRenderIfRendered();
    }

    public TreeNodeInfoExtractor<RECORD> getTreeNodeInfoExtractor() {
        return this.treeNodeInfoExtractor;
    }

    public void setTreeNodeInfoExtractor(TreeNodeInfoExtractor<RECORD> treeNodeInfoExtractor) {
        this.treeNodeInfoExtractor = treeNodeInfoExtractor;
    }
}

