/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.teamapps.core.TeamAppsUploadManager;
import org.teamapps.dto.UiClientInfo;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiQuery;
import org.teamapps.dto.UiSessionClosingReason;
import org.teamapps.icons.IconProvider;
import org.teamapps.icons.SessionIconProvider;
import org.teamapps.server.UxServerContext;
import org.teamapps.uisession.QualifiedUiSessionId;
import org.teamapps.uisession.TeamAppsComponentNotFoundException;
import org.teamapps.uisession.TeamAppsSessionNotFoundException;
import org.teamapps.uisession.UiCommandExecutor;
import org.teamapps.uisession.UiSessionListener;
import org.teamapps.ux.component.ClientObject;
import org.teamapps.ux.component.template.BaseTemplate;
import org.teamapps.ux.json.UxJacksonSerializationTemplate;
import org.teamapps.ux.session.ClientInfo;
import org.teamapps.ux.session.SessionConfiguration;
import org.teamapps.ux.session.SessionContext;
import org.teamapps.webcontroller.WebController;

public class TeamAppsUxSessionManager
implements UiSessionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TeamAppsUxSessionManager.class);
    private final WebController webController;
    private final UiCommandExecutor commandExecutor;
    private final ObjectMapper objectMapper;
    private final IconProvider iconProvider;
    private final TeamAppsUploadManager uploadManager;
    private final Map<QualifiedUiSessionId, SessionContext> sessionContextById = new ConcurrentHashMap<QualifiedUiSessionId, SessionContext>();
    private final UxServerContext uxServerContext = new UxServerContext(){

        @Override
        public SessionContext getSessionContextById(QualifiedUiSessionId sessionId) {
            return TeamAppsUxSessionManager.this.sessionContextById.get(sessionId);
        }

        @Override
        public File getUploadedFileByUuid(String uuid) {
            return TeamAppsUxSessionManager.this.uploadManager.getUploadedFile(uuid);
        }
    };

    public TeamAppsUxSessionManager(WebController webController, UiCommandExecutor commandExecutor, ObjectMapper objectMapper, IconProvider iconProvider, TeamAppsUploadManager uploadManager) {
        this.webController = webController;
        this.commandExecutor = commandExecutor;
        this.objectMapper = objectMapper;
        this.iconProvider = iconProvider;
        this.uploadManager = uploadManager;
    }

    @Override
    public void onUiSessionStarted(QualifiedUiSessionId sessionId, UiClientInfo uiClientInfo, HttpSession httpSession) {
        ClientInfo clientInfo = new ClientInfo(uiClientInfo.getIp(), uiClientInfo.getScreenWidth(), uiClientInfo.getScreenHeight(), uiClientInfo.getViewPortWidth(), uiClientInfo.getViewPortHeight(), uiClientInfo.getPreferredLanguageIso(), uiClientInfo.getHighDensityScreen(), uiClientInfo.getTimezoneIana(), uiClientInfo.getTimezoneOffsetMinutes(), uiClientInfo.getClientTokens(), uiClientInfo.getUserAgentString(), uiClientInfo.getClientUrl(), uiClientInfo.getClientParameters());
        SessionConfiguration sessionConfiguration = SessionConfiguration.createForClientInfo(clientInfo);
        SessionContext sessionContext = new SessionContext(sessionId, clientInfo, sessionConfiguration, httpSession, this.commandExecutor, this.uxServerContext, new SessionIconProvider(this.iconProvider));
        this.sessionContextById.put(sessionId, sessionContext);
        CompletableFuture<Void> future = sessionContext.runWithContext(() -> {
            sessionContext.registerTemplates(Arrays.stream(BaseTemplate.values()).collect(Collectors.toMap(Enum::name, BaseTemplate::getTemplate)));
            this.webController.onSessionStart(sessionContext);
        });
        try {
            future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onUiSessionClientRefresh(QualifiedUiSessionId sessionId, UiClientInfo clientInfo, HttpSession httpSession) {
        this.onUiSessionStarted(sessionId, clientInfo, httpSession);
    }

    @Override
    public void onActivityStateChanged(QualifiedUiSessionId sessionId, boolean active) {
        SessionContext context = this.sessionContextById.get(sessionId);
        if (context != null) {
            context.handleActivityStateChangedInternal(active);
        }
    }

    @Override
    public void onUiSessionClosed(QualifiedUiSessionId sessionId, UiSessionClosingReason reason) {
        SessionContext context = this.sessionContextById.remove(sessionId);
        if (context != null) {
            context.handleSessionDestroyedInternal();
        }
    }

    @Override
    public CompletableFuture<Void> onUiEvent(QualifiedUiSessionId sessionId, UiEvent event) {
        SessionContext sessionContext = this.sessionContextById.get(sessionId);
        if (sessionContext != null) {
            return sessionContext.runWithContext(() -> {
                String uiComponentId = event.getComponentId();
                ClientObject clientObject = sessionContext.getClientObject(uiComponentId);
                if (clientObject == null) {
                    throw new TeamAppsComponentNotFoundException(sessionId, uiComponentId);
                }
                clientObject.handleUiEvent(event);
            });
        }
        return CompletableFuture.failedFuture(new TeamAppsSessionNotFoundException(sessionId));
    }

    @Override
    public void onUiQuery(QualifiedUiSessionId sessionId, UiQuery query, Consumer<Object> resultCallback, Consumer<Throwable> errorCallback) {
        SessionContext sessionContext = this.sessionContextById.get(sessionId);
        if (sessionContext != null) {
            sessionContext.runWithContext(() -> {
                String uiComponentId = query.getComponentId();
                ClientObject clientObject = sessionContext.getClientObject(uiComponentId);
                if (clientObject != null) {
                    clientObject.handleUiQuery(query).handle((result, throwable) -> {
                        if (throwable != null) {
                            errorCallback.accept((Throwable)throwable);
                        } else {
                            new UxJacksonSerializationTemplate(sessionContext).doWithUxJacksonSerializers(() -> resultCallback.accept(result));
                        }
                        return null;
                    });
                } else {
                    errorCallback.accept(new TeamAppsComponentNotFoundException(sessionId, uiComponentId));
                }
            });
        } else {
            errorCallback.accept(new TeamAppsSessionNotFoundException(sessionId));
        }
    }

    public SessionContext getSessionContext(QualifiedUiSessionId sessionId) {
        return this.sessionContextById.get(sessionId);
    }
}

