/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.chat;

import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiChatDisplay;
import org.teamapps.dto.UiChatFile;
import org.teamapps.dto.UiChatMessage;
import org.teamapps.dto.UiChatPhoto;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.chat.ChatDisplayModel;
import org.teamapps.ux.component.chat.ChatFile;
import org.teamapps.ux.component.chat.ChatMessage;
import org.teamapps.ux.component.chat.ChatMessageBatch;
import org.teamapps.ux.component.chat.ChatPhoto;

public class ChatDisplay
extends AbstractComponent {
    private final ChatDisplayModel model;
    private int messagesFetchSize = 30;

    public ChatDisplay(ChatDisplayModel model) {
        this.model = model;
        model.onMessagesAdded().addListener(chatMessages -> this.queueCommandIfRendered(() -> new UiChatDisplay.AddChatMessagesCommand(this.getId(), this.createUiChatMessages(chatMessages.getMessages()), false, chatMessages.isIncludesFirstMessage())));
        model.onAllDataChanged().addListener(aVoid -> {
            ChatMessageBatch messageBatch = this.getModel().getLastChatMessages(this.messagesFetchSize);
            this.queueCommandIfRendered(() -> new UiChatDisplay.ReplaceChatMessagesCommand(this.getId(), this.createUiChatMessages(messageBatch.getMessages()), messageBatch.isIncludesFirstMessage()));
        });
    }

    public UiChatDisplay createUiComponent() {
        UiChatDisplay uiChatDisplay = new UiChatDisplay();
        this.mapAbstractUiComponentProperties((UiComponent)uiChatDisplay);
        ChatMessageBatch modelResponse = this.model.getLastChatMessages(this.messagesFetchSize);
        uiChatDisplay.setMessages(this.createUiChatMessages(modelResponse.getMessages()));
        uiChatDisplay.setIncludesFirstMessage(modelResponse.isIncludesFirstMessage());
        return uiChatDisplay;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_CHAT_DISPLAY_PREVIOUS_MESSAGES_REQUESTED: {
                UiChatDisplay.PreviousMessagesRequestedEvent requestedEvent = (UiChatDisplay.PreviousMessagesRequestedEvent)event;
                ChatMessageBatch response = this.model.getPreviousMessages(requestedEvent.getEarliestKnownMessageId(), this.messagesFetchSize);
                this.queueCommandIfRendered(() -> new UiChatDisplay.AddChatMessagesCommand(this.getId(), this.createUiChatMessages(response.getMessages()), true, response.isIncludesFirstMessage()));
            }
        }
    }

    private List<UiChatMessage> createUiChatMessages(List<ChatMessage> chatMessages) {
        return chatMessages.stream().map(message -> this.createUiChatMessage((ChatMessage)message)).collect(Collectors.toList());
    }

    private UiChatMessage createUiChatMessage(ChatMessage message) {
        UiChatMessage uiChatMessage = new UiChatMessage();
        uiChatMessage.setId(message.getId());
        uiChatMessage.setUserNickname(message.getUserNickname());
        uiChatMessage.setUserImageUrl(message.getUserImage().getUrl(this.getSessionContext()));
        uiChatMessage.setText(message.getText());
        uiChatMessage.setPhotos(message.getPhotos() != null ? message.getPhotos().stream().map(photo -> this.createUiChatPhoto((ChatPhoto)photo)).collect(Collectors.toList()) : null);
        uiChatMessage.setFiles(message.getFiles() != null ? message.getFiles().stream().map(file -> this.createUiChatFile((ChatFile)file)).collect(Collectors.toList()) : null);
        return uiChatMessage;
    }

    private UiChatPhoto createUiChatPhoto(ChatPhoto photo) {
        UiChatPhoto uiChatPhoto = new UiChatPhoto();
        uiChatPhoto.setThumbnailUrl(photo.getThumbnail() != null ? photo.getThumbnail().getUrl(this.getSessionContext()) : null);
        uiChatPhoto.setImageUrl(photo.getImage().getUrl(this.getSessionContext()));
        return uiChatPhoto;
    }

    private UiChatFile createUiChatFile(ChatFile file) {
        UiChatFile uiChatFile = new UiChatFile();
        uiChatFile.setName(file.getName());
        uiChatFile.setIcon(this.getSessionContext().resolveIcon(file.getIcon()));
        uiChatFile.setLength(file.getLength());
        uiChatFile.setThumbnailUrl(file.getThumbnail() != null ? file.getThumbnail().getUrl(this.getSessionContext()) : null);
        uiChatFile.setDownloadUrl(file.getDownload().getUrl(this.getSessionContext()));
        return uiChatFile;
    }

    public ChatDisplayModel getModel() {
        return this.model;
    }

    public int getMessagesFetchSize() {
        return this.messagesFetchSize;
    }

    public void setMessagesFetchSize(int messagesFetchSize) {
        this.messagesFetchSize = messagesFetchSize;
        this.reRenderIfRendered();
    }
}

