/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.form.layoutpolicy;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiFormLayoutPolicy;
import org.teamapps.ux.component.form.layoutpolicy.FormSection;

public class FormLayoutPolicy {
    private int minWidth;
    private List<FormSection> sections = new ArrayList<FormSection>();

    public List<FormSection> getSections() {
        return this.sections;
    }

    public FormLayoutPolicy addSection(FormSection section) {
        this.sections.add(section);
        return this;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public FormLayoutPolicy setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    public FormLayoutPolicy setSections(List<FormSection> sections) {
        this.sections = sections;
        return this;
    }

    public UiFormLayoutPolicy createUiLayoutPolicy() {
        List uiSections = this.sections.stream().map(section -> section != null ? section.createUiFormSection() : null).collect(Collectors.toList());
        return new UiFormLayoutPolicy(this.minWidth, uiSections);
    }
}

