/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid.bootstrap;

import java.util.EnumMap;
import java.util.Map;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.format.HorizontalElementAlignment;
import org.teamapps.ux.component.format.VerticalElementAlignment;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishBreakpoint;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishGridLayout;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishRow;
import org.teamapps.ux.component.grid.bootstrap.BootstrapishSizing;

public class BootstrapishPlacement {
    private final Component component;
    private final Map<BootstrapishBreakpoint, BootstrapishSizing> sizings = new EnumMap<BootstrapishBreakpoint, BootstrapishSizing>(BootstrapishBreakpoint.class);
    private VerticalElementAlignment verticalAlignment = null;
    private HorizontalElementAlignment horizontalAlignment = null;

    public BootstrapishPlacement(Component component) {
        this.sizings.put(BootstrapishBreakpoint.XS, new BootstrapishSizing(BootstrapishBreakpoint.XS, 0, -1));
        this.component = component;
    }

    public VerticalElementAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public BootstrapishPlacement setVerticalAlignment(VerticalElementAlignment verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    public HorizontalElementAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public BootstrapishPlacement setHorizontalAlignment(HorizontalElementAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    private BootstrapishSizing getOrCreateSizing(BootstrapishBreakpoint breakpoint) {
        BootstrapishSizing sizing = this.sizings.computeIfAbsent(breakpoint, responsiveBreakpoint -> new BootstrapishSizing(breakpoint));
        BootstrapishSizing smallerSizing = this.sizings.get((Object)BootstrapishBreakpoint.XS);
        for (int i = 1; i < BootstrapishBreakpoint.values().length; ++i) {
            BootstrapishSizing nextSizing = this.sizings.get((Object)BootstrapishBreakpoint.values()[i]);
            if (nextSizing == null) continue;
            nextSizing.setSmallerSizing(smallerSizing);
            smallerSizing = nextSizing;
        }
        return sizing;
    }

    public BootstrapishPlacement colXs(int colSpan) {
        this.getOrCreateSizing(BootstrapishBreakpoint.XS).setColSpan(colSpan);
        return this;
    }

    public BootstrapishPlacement colSm(int colSpan) {
        this.getOrCreateSizing(BootstrapishBreakpoint.SM).setColSpan(colSpan);
        return this;
    }

    public BootstrapishPlacement colMd(int colSpan) {
        this.getOrCreateSizing(BootstrapishBreakpoint.MD).setColSpan(colSpan);
        return this;
    }

    public BootstrapishPlacement colLg(int colSpan) {
        this.getOrCreateSizing(BootstrapishBreakpoint.LG).setColSpan(colSpan);
        return this;
    }

    public BootstrapishPlacement colXl(int colSpan) {
        this.getOrCreateSizing(BootstrapishBreakpoint.XL).setColSpan(colSpan);
        return this;
    }

    public BootstrapishPlacement offsetXs(int offset) {
        this.getOrCreateSizing(BootstrapishBreakpoint.XS).setOffset(offset);
        return this;
    }

    public BootstrapishPlacement offsetSm(int offset) {
        this.getOrCreateSizing(BootstrapishBreakpoint.SM).setOffset(offset);
        return this;
    }

    public BootstrapishPlacement offsetMd(int offset) {
        this.getOrCreateSizing(BootstrapishBreakpoint.MD).setOffset(offset);
        return this;
    }

    public BootstrapishPlacement offsetLg(int offset) {
        this.getOrCreateSizing(BootstrapishBreakpoint.LG).setOffset(offset);
        return this;
    }

    public BootstrapishPlacement offsetXl(int offset) {
        this.getOrCreateSizing(BootstrapishBreakpoint.XL).setOffset(offset);
        return this;
    }

    public Component getComponent() {
        return this.component;
    }

    public Map<BootstrapishBreakpoint, BootstrapishSizing> getSizings() {
        return this.sizings;
    }

    public BootstrapishSizing getSizingForBreakPoint(BootstrapishBreakpoint breakpoint) {
        for (int breakpointOrdinal = breakpoint.ordinal(); breakpointOrdinal > 0; --breakpointOrdinal) {
            BootstrapishSizing sizing = this.sizings.get((Object)BootstrapishBreakpoint.values()[breakpointOrdinal]);
            if (sizing == null) continue;
            return sizing;
        }
        return this.sizings.get((Object)BootstrapishBreakpoint.XS);
    }

    public static class ChainBuilder {
        private final BootstrapishPlacement placement;
        private final BootstrapishRow.ChainBuilder parent;

        public ChainBuilder(Component component, BootstrapishRow.ChainBuilder parent) {
            this.placement = new BootstrapishPlacement(component);
            this.parent = parent;
        }

        public ChainBuilder addPlacement(Component component) {
            this.parent.addPlacement(this.placement);
            return this.parent.addPlacement(component);
        }

        public BootstrapishRow.ChainBuilder addRow() {
            this.parent.addPlacement(this.placement);
            return this.parent.addRow();
        }

        public BootstrapishGridLayout done() {
            this.parent.addPlacement(this.placement);
            return this.parent.done();
        }

        public ChainBuilder colXs(int colSpan) {
            this.placement.colXs(colSpan);
            return this;
        }

        public ChainBuilder colSm(int colSpan) {
            this.placement.colSm(colSpan);
            return this;
        }

        public ChainBuilder colMd(int colSpan) {
            this.placement.colMd(colSpan);
            return this;
        }

        public ChainBuilder colLg(int colSpan) {
            this.placement.colLg(colSpan);
            return this;
        }

        public ChainBuilder colXl(int colSpan) {
            this.placement.colXl(colSpan);
            return this;
        }

        public ChainBuilder offsetXs(int offset) {
            this.placement.offsetXs(offset);
            return this;
        }

        public ChainBuilder offsetSm(int offset) {
            this.placement.offsetSm(offset);
            return this;
        }

        public ChainBuilder offsetMd(int offset) {
            this.placement.offsetMd(offset);
            return this;
        }

        public ChainBuilder offsetLg(int offset) {
            this.placement.offsetLg(offset);
            return this;
        }

        public ChainBuilder offsetXl(int offset) {
            this.placement.offsetXl(offset);
            return this;
        }

        public ChainBuilder verticalAlignment(VerticalElementAlignment verticalAlignment) {
            this.placement.setVerticalAlignment(verticalAlignment);
            return this;
        }

        public ChainBuilder horizontalAlignment(HorizontalElementAlignment horizontalAlignment) {
            this.placement.setHorizontalAlignment(horizontalAlignment);
            return this;
        }
    }
}

