/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.webrtc.apiclient;

import java.util.Set;
import org.teamapps.ux.component.webrtc.apiclient.MediaKind;
import org.teamapps.ux.component.webrtc.apiclient.StreamFileRequest;

public class StreamFileRequestBuilder {
    private String streamUuid;
    private Set<MediaKind> kinds;
    private String filePath;
    private boolean relativePath;
    private boolean restartOnExit = false;
    private Integer videoBitrate = null;
    private Integer width;
    private Integer height;
    private Float frameRate;
    private Integer audioSampleRate;
    private Integer audioChannels;
    private String[] additionalInputOptions;

    public StreamFileRequestBuilder(String streamUuid, Set<MediaKind> kinds, String filePath, boolean relativePath) {
        this.streamUuid = streamUuid;
        this.kinds = kinds;
        this.filePath = filePath;
        this.relativePath = relativePath;
    }

    public StreamFileRequestBuilder setStreamUuid(String streamUuid) {
        this.streamUuid = streamUuid;
        return this;
    }

    public StreamFileRequestBuilder setKinds(Set<MediaKind> kinds) {
        this.kinds = kinds;
        return this;
    }

    public StreamFileRequestBuilder setFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    public StreamFileRequestBuilder setRelativePath(boolean relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public StreamFileRequestBuilder setRestartOnExit(boolean restartOnExit) {
        this.restartOnExit = restartOnExit;
        return this;
    }

    public StreamFileRequestBuilder setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
        return this;
    }

    public StreamFileRequestBuilder setWidth(int width) {
        this.width = width;
        return this;
    }

    public StreamFileRequestBuilder setHeight(int height) {
        this.height = height;
        return this;
    }

    public StreamFileRequestBuilder setFrameRate(float frameRate) {
        this.frameRate = Float.valueOf(frameRate);
        return this;
    }

    public StreamFileRequestBuilder setAudioSampleRate(int audioSampleRate) {
        this.audioSampleRate = audioSampleRate;
        return this;
    }

    public StreamFileRequestBuilder setAudioChannels(int audioChannels) {
        this.audioChannels = audioChannels;
        return this;
    }

    public StreamFileRequestBuilder setAdditionalInputOptions(String[] additionalInputOptions) {
        this.additionalInputOptions = additionalInputOptions;
        return this;
    }

    public StreamFileRequest build() {
        return new StreamFileRequest(this.streamUuid, this.kinds, this.filePath, this.relativePath, this.restartOnExit, this.videoBitrate, this.width, this.height, this.frameRate, this.audioSampleRate, this.audioChannels, this.additionalInputOptions);
    }
}

