/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ReflectionUtil {
    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate) {
        ArrayList<Field> matchingFields = new ArrayList<Field>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Field field : c.getDeclaredFields()) {
                if (!predicate.test(field)) continue;
                matchingFields.add(field);
            }
        }
        return matchingFields;
    }

    public static Field findField(Class<?> clazz, Predicate<Field> predicate) {
        List<Field> fields = ReflectionUtil.findFields(clazz, predicate);
        return fields.size() > 0 ? fields.get(0) : null;
    }

    public static Field findField(Class<?> clazz, String fieldName) {
        return ReflectionUtil.findField(clazz, (Field field) -> field.getName().equals(fieldName));
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate) {
        ArrayList<Method> matchingFields = new ArrayList<Method>();
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!predicate.test(method)) continue;
                matchingFields.add(method);
            }
        }
        return matchingFields;
    }

    public static Method findMethod(Class<?> clazz, Predicate<Method> predicate) {
        List<Method> methods = ReflectionUtil.findMethods(clazz, predicate);
        return methods.size() > 0 ? methods.get(0) : null;
    }

    public static Method findMethod(Class<?> clazz, String methodName) {
        return ReflectionUtil.findMethod(clazz, (Method method) -> method.getName().equals(methodName));
    }

    public static Method findMethodByName(Class<?> clazz, String methodName) {
        return ReflectionUtil.findMethod(clazz, (Method method) -> method.getName().equals(methodName));
    }

    public static Method findGetter(Class<?> clazz, String propertyName) {
        return ReflectionUtil.findMethods(clazz, method -> (method.getName().equals("get" + StringUtils.capitalize((String)propertyName)) || method.getName().equals("is" + StringUtils.capitalize((String)propertyName))) && method.getParameterCount() == 0).stream().findFirst().orElse(null);
    }

    public static Method findSetter(Class<?> clazz, String propertyName) {
        return ReflectionUtil.findMethods(clazz, method -> method.getName().equals("set" + StringUtils.capitalize((String)propertyName)) && method.getParameterCount() == 1).stream().findFirst().orElse(null);
    }

    public static <V> V getPropertyValue(Object o, String propertyName) {
        return (V)ReflectionUtil.invokeMethod(o, ReflectionUtil.findGetter(o.getClass(), propertyName), new Object[0]);
    }

    public static <V> void setProperty(Object o, String propertyName, V value) {
        ReflectionUtil.invokeMethod(o, ReflectionUtil.findSetter(o.getClass(), propertyName), value);
    }

    public static String toStringUsingReflection(Object o) {
        if (o == null) {
            return "";
        }
        Method toString = ReflectionUtil.findMethods(o.getClass(), method -> method.getName().equals("toString") && method.getParameterTypes().length == 0).stream().findFirst().orElse(null);
        if (toString.getDeclaringClass() != Object.class) {
            return "" + o;
        }
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)new ToStringStyle(){
            {
                this.setUseShortClassName(true);
                this.setUseIdentityHashCode(false);
                this.setContentStart(" {");
                this.setFieldSeparator(SystemUtils.LINE_SEPARATOR + "  ");
                this.setFieldSeparatorAtStart(true);
                this.setContentEnd(SystemUtils.LINE_SEPARATOR + "}");
            }

            public void appendSuper(StringBuffer buffer, String superToString) {
                super.appendSuper(buffer, superToString);
            }
        });
    }

    public static <RECORD> Object invokeMethod(RECORD object, Method method, Object ... parameters) {
        try {
            return method.invoke(object, parameters);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            String expectedParameterTypesString = Arrays.stream(method.getParameterTypes()).map(paramClass -> paramClass.getSimpleName()).collect(Collectors.joining(", "));
            String actualParameterTypesString = Arrays.stream(parameters).map(p -> p == null ? "null" : p.getClass().getSimpleName()).collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Could not invoke method " + method.getName() + "(" + expectedParameterTypesString + ") with given parameter types: " + actualParameterTypesString, e);
        }
    }

    public static <RECORD> Object readField(RECORD object, Field field, boolean makeAccessibleIfNecessary) {
        try {
            if (makeAccessibleIfNecessary && !field.canAccess(object)) {
                field.setAccessible(true);
            }
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <RECORD> void setField(RECORD object, Field field, Object value, boolean makeAccessibleIfNecessary) {
        try {
            if (makeAccessibleIfNecessary && !field.canAccess(object)) {
                field.setAccessible(true);
            }
            field.set(object, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

