/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.field;

import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.UiField;
import org.teamapps.dto.UiImageField;
import org.teamapps.ux.component.absolutelayout.Length;
import org.teamapps.ux.component.field.AbstractField;
import org.teamapps.ux.component.format.Border;
import org.teamapps.ux.component.format.ImageSizing;

public class ImageField
extends AbstractField<String> {
    private Length width = Length.AUTO;
    private Length height = Length.AUTO;
    private Border border;
    private ImageSizing imageSizing = ImageSizing.CONTAIN;
    private Color backgroundColor = RgbaColor.TRANSPARENT;

    public UiImageField createUiComponent() {
        UiImageField uiImageField = new UiImageField();
        this.mapAbstractFieldAttributesToUiField((UiField)uiImageField);
        uiImageField.setWidth(this.width.toCssString());
        uiImageField.setHeight(this.height.toCssString());
        uiImageField.setBorder(this.border != null ? this.border.createUiBorder() : null);
        uiImageField.setImageSizing(this.imageSizing.toUiImageSizing());
        uiImageField.setBackgroundColor(this.backgroundColor != null ? this.backgroundColor.toHtmlColorString() : null);
        return uiImageField;
    }

    public Length getWidth() {
        return this.width;
    }

    public ImageField setWidth(Length width) {
        this.width = width;
        this.queueCommandIfRendered(() -> new UiImageField.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public Length getHeight() {
        return this.height;
    }

    public ImageField setHeight(Length height) {
        this.height = height;
        this.queueCommandIfRendered(() -> new UiImageField.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public Border getBorder() {
        return this.border;
    }

    public ImageField setBorder(Border border) {
        this.border = border;
        this.queueCommandIfRendered(() -> new UiImageField.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public ImageSizing getImageSizing() {
        return this.imageSizing;
    }

    public ImageField setImageSizing(ImageSizing imageSizing) {
        this.imageSizing = imageSizing;
        this.queueCommandIfRendered(() -> new UiImageField.UpdateCommand(this.getId(), this.createUiComponent()));
        return this;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.queueCommandIfRendered(() -> new UiImageField.UpdateCommand(this.getId(), this.createUiComponent()));
    }
}

