/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.timegraph;

import java.util.ArrayList;
import java.util.List;
import org.teamapps.common.format.Color;
import org.teamapps.common.format.RgbaColor;
import org.teamapps.dto.AbstractUiLineChartDataDisplay;
import org.teamapps.dto.UiLineChartBand;
import org.teamapps.ux.component.timegraph.AbstractLineChartDataDisplay;
import org.teamapps.ux.component.timegraph.LineChartCurveType;

public class LineChartBand
extends AbstractLineChartDataDisplay {
    private final String upperBoundDataSeriesId;
    private final String middleLineDataSeriesId;
    private final String lowerBoundDataSeriesId;
    private LineChartCurveType curveType;
    private float dataDotRadius;
    private Color centerLineColor;
    private Color lowerLineColor;
    private Color upperLineColor;
    private Color areaColor;

    public LineChartBand(String upperBoundDataSeriesId, String middleLineDataSeriesId, String lowerBoundDataSeriesId) {
        this(upperBoundDataSeriesId, middleLineDataSeriesId, lowerBoundDataSeriesId, LineChartCurveType.MONOTONE, 2.0f, (Color)Color.fromRgb((int)73, (int)128, (int)192));
    }

    public LineChartBand(String upperBoundDataSeriesId, String middleLineDataSeriesId, String lowerBoundDataSeriesId, LineChartCurveType curveType, float dataDotRadius, Color centerLineColor) {
        this(upperBoundDataSeriesId, middleLineDataSeriesId, lowerBoundDataSeriesId, curveType, dataDotRadius, centerLineColor, null);
    }

    public LineChartBand(String upperBoundDataSeriesId, String middleLineDataSeriesId, String lowerBoundDataSeriesId, LineChartCurveType curveType, float dataDotRadius, Color centerLineColor, Color areaColor) {
        this.upperBoundDataSeriesId = upperBoundDataSeriesId;
        this.middleLineDataSeriesId = middleLineDataSeriesId;
        this.lowerBoundDataSeriesId = lowerBoundDataSeriesId;
        this.curveType = curveType;
        this.dataDotRadius = dataDotRadius;
        this.centerLineColor = centerLineColor;
        this.lowerLineColor = centerLineColor instanceof RgbaColor ? ((RgbaColor)centerLineColor).withAlpha(((RgbaColor)centerLineColor).getAlpha() / 4.0f) : RgbaColor.TRANSPARENT;
        this.upperLineColor = centerLineColor instanceof RgbaColor ? ((RgbaColor)centerLineColor).withAlpha(((RgbaColor)centerLineColor).getAlpha() / 4.0f) : RgbaColor.TRANSPARENT;
        this.areaColor = areaColor;
    }

    public UiLineChartBand createUiFormat() {
        UiLineChartBand ui = new UiLineChartBand();
        this.mapAbstractLineChartDataDisplayProperties((AbstractUiLineChartDataDisplay)ui);
        ui.setUpperBoundDataSeriesId(this.upperBoundDataSeriesId);
        ui.setMiddleLineDataSeriesId(this.middleLineDataSeriesId);
        ui.setLowerBoundDataSeriesId(this.lowerBoundDataSeriesId);
        ui.setGraphType(this.curveType.toUiLineChartCurveType());
        ui.setDataDotRadius(this.dataDotRadius);
        ui.setMiddleLineColor(this.centerLineColor != null ? this.centerLineColor.toHtmlColorString() : null);
        ui.setLowerLineColor(this.lowerLineColor != null ? this.lowerLineColor.toHtmlColorString() : null);
        ui.setUpperLineColor(this.upperLineColor != null ? this.upperLineColor.toHtmlColorString() : null);
        ui.setAreaColor(this.areaColor != null ? this.areaColor.toHtmlColorString() : null);
        return ui;
    }

    @Override
    public List<String> getDataSeriesIds() {
        ArrayList<String> dataSeriesIds = new ArrayList<String>();
        if (this.upperBoundDataSeriesId != null) {
            dataSeriesIds.add(this.upperBoundDataSeriesId);
        }
        if (this.middleLineDataSeriesId != null) {
            dataSeriesIds.add(this.middleLineDataSeriesId);
        }
        if (this.lowerBoundDataSeriesId != null) {
            dataSeriesIds.add(this.lowerBoundDataSeriesId);
        }
        return dataSeriesIds;
    }

    public LineChartCurveType getCurveType() {
        return this.curveType;
    }

    public LineChartBand setCurveType(LineChartCurveType curveType) {
        this.curveType = curveType;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public float getDataDotRadius() {
        return this.dataDotRadius;
    }

    public LineChartBand setDataDotRadius(float dataDotRadius) {
        this.dataDotRadius = dataDotRadius;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getCenterLineColor() {
        return this.centerLineColor;
    }

    public LineChartBand setCenterLineColor(Color centerLineColor) {
        this.centerLineColor = centerLineColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getAreaColor() {
        return this.areaColor;
    }

    public LineChartBand setAreaColor(Color areaColor) {
        this.areaColor = areaColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getLowerLineColor() {
        return this.lowerLineColor;
    }

    public LineChartBand setLowerLineColor(Color lowerLineColor) {
        this.lowerLineColor = lowerLineColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }

    public Color getUpperLineColor() {
        return this.upperLineColor;
    }

    public LineChartBand setUpperLineColor(Color upperLineColor) {
        this.upperLineColor = upperLineColor;
        if (this.changeListener != null) {
            this.changeListener.handleChange(this);
        }
        return this;
    }
}

