/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.infiniteitemview;

import java.util.Objects;

public class ItemRange {
    private final int start;
    private final int length;

    public static ItemRange startEnd(int start, int endExclusive) {
        return new ItemRange(start, endExclusive - start);
    }

    public static ItemRange startLength(int start, int length) {
        return new ItemRange(start, length);
    }

    private ItemRange(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public int getStart() {
        return this.start;
    }

    public int getLength() {
        return this.length;
    }

    public int getEnd() {
        return this.start + this.length;
    }

    public boolean overlaps(ItemRange other) {
        return this.length > 0 && other.length > 0 && this.start < other.getEnd() && this.getEnd() > other.start;
    }

    public String toString() {
        return "ItemRange{start=" + this.start + ", end=" + this.getEnd() + ", length=" + this.length + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemRange itemRange = (ItemRange)o;
        return this.start == itemRange.start && this.length == itemRange.length;
    }

    public int hashCode() {
        return Objects.hash(this.start, this.length);
    }
}

