/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.map;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.teamapps.data.extract.BeanPropertyExtractor;
import org.teamapps.data.extract.PropertyExtractor;
import org.teamapps.data.extract.PropertyProvider;
import org.teamapps.dto.UiComponent;
import org.teamapps.dto.UiEvent;
import org.teamapps.dto.UiMap2;
import org.teamapps.dto.UiMapArea;
import org.teamapps.dto.UiMapCircle;
import org.teamapps.dto.UiMapMarkerClientRecord;
import org.teamapps.dto.UiMapMarkerCluster;
import org.teamapps.dto.UiMapPolygon;
import org.teamapps.dto.UiMapPolyline;
import org.teamapps.dto.UiMapRectangle;
import org.teamapps.event.Event;
import org.teamapps.ux.component.AbstractComponent;
import org.teamapps.ux.component.field.combobox.TemplateDecider;
import org.teamapps.ux.component.map.Area;
import org.teamapps.ux.component.map.Location;
import org.teamapps.ux.component.map.LocationChangedEventData;
import org.teamapps.ux.component.map.Marker;
import org.teamapps.ux.component.map.shape.AbstractMapShape;
import org.teamapps.ux.component.map.shape.MapCircle;
import org.teamapps.ux.component.map.shape.MapPolygon;
import org.teamapps.ux.component.map.shape.MapPolyline;
import org.teamapps.ux.component.map.shape.MapRectangle;
import org.teamapps.ux.component.template.Template;

public class MapView2<RECORD>
extends AbstractComponent {
    public final Event<LocationChangedEventData> onLocationChanged = new Event();
    public final Event<Float> onZoomLevelChanged = new Event();
    public final Event<Location> onMapClicked = new Event();
    public final Event<Marker<RECORD>> onMarkerClicked = new Event();
    public final Event<AbstractMapShape> onShapeDrawn = new Event();
    private final String baseApiUrl;
    private final String accessToken;
    private String styleUrl;
    private boolean displayAttributionControl = true;
    private float zoomLevel = 10.0f;
    private Location location = new Location(0.0, 0.0);
    private final Map<String, AbstractMapShape> shapesByClientId = new HashMap<String, AbstractMapShape>();
    private List<Marker<RECORD>> clusterMarkers = new ArrayList<Marker<RECORD>>();
    private int clientIdCounter = 0;
    private final BidiMap<Integer, Marker<RECORD>> markersByClientId = new DualHashBidiMap();
    private Template defaultTemplate;
    private TemplateDecider<Marker<RECORD>> templateDecider = m -> this.defaultTemplate;
    private final Map<Template, String> templateIdsByTemplate = new HashMap<Template, String>();
    private int templateIdCounter = 0;
    private PropertyProvider<RECORD> markerPropertyProvider = new BeanPropertyExtractor();
    private final AbstractMapShape.MapShapeListener shapeListener = new AbstractMapShape.MapShapeListener(){

        @Override
        public void handleChanged(AbstractMapShape shape) {
            MapView2.this.queueCommandIfRendered(() -> new UiMap2.UpdateShapeCommand(MapView2.this.getId(), shape.getClientIdInternal(), shape.createUiMapShape()));
        }

        @Override
        public void handleRemoved(AbstractMapShape shape) {
            MapView2.this.queueCommandIfRendered(() -> new UiMap2.RemoveShapeCommand(MapView2.this.getId(), shape.getClientIdInternal()));
        }
    };

    public MapView2(String baseApiUrl, String accessToken, String styleUrl) {
        this.baseApiUrl = baseApiUrl;
        this.accessToken = accessToken;
        this.styleUrl = styleUrl;
    }

    @Override
    public UiComponent createUiComponent() {
        UiMap2 uiMap = new UiMap2(this.templateIdsByTemplate.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((Template)entry.getKey()).createUiTemplate())));
        this.mapAbstractUiComponentProperties((UiComponent)uiMap);
        uiMap.setBaseApiUrl(this.baseApiUrl);
        uiMap.setAccessToken(this.accessToken);
        uiMap.setStyleUrl(this.styleUrl);
        uiMap.setDisplayAttributionControl(this.displayAttributionControl);
        uiMap.setZoomLevel(this.zoomLevel);
        HashMap uiShapes = new HashMap();
        this.shapesByClientId.forEach((id, shape) -> uiShapes.put(id, shape.createUiMapShape()));
        uiMap.setShapes(uiShapes);
        if (this.location != null) {
            uiMap.setMapPosition(this.location.createUiLocation());
        }
        if (this.clusterMarkers != null && !this.clusterMarkers.isEmpty()) {
            uiMap.setMarkerCluster(new UiMapMarkerCluster(this.clusterMarkers.stream().map(marker -> this.createUiMarkerRecord((Marker<RECORD>)marker, (Integer)this.markersByClientId.getKey(marker))).collect(Collectors.toList())));
        }
        uiMap.setMarkers(this.markersByClientId.entrySet().stream().map(e -> this.createUiMarkerRecord((Marker)e.getValue(), (Integer)e.getKey())).collect(Collectors.toList()));
        return uiMap;
    }

    private UiMapMarkerClientRecord createUiMarkerRecord(Marker<RECORD> marker, int clientId) {
        UiMapMarkerClientRecord clientRecord = new UiMapMarkerClientRecord();
        clientRecord.setId(clientId);
        clientRecord.setLocation(marker.getLocation().createUiLocation());
        Template template = this.getTemplateForRecord(marker, this.templateDecider);
        if (template != null) {
            clientRecord.setTemplateId(this.templateIdsByTemplate.get(template));
            clientRecord.setValues(this.markerPropertyProvider.getValues(marker.getData(), template.getDataKeys()));
        } else {
            clientRecord.setAsString("" + marker.getData());
        }
        clientRecord.setOffsetPixelsX(marker.getOffsetPixelsX());
        clientRecord.setOffsetPixelsY(marker.getOffsetPixelsY());
        clientRecord.setAnchor(marker.getMarkerAnchor().toUiMapMarkerAnchor());
        return clientRecord;
    }

    @Override
    public void handleUiEvent(UiEvent event) {
        switch (event.getUiEventType()) {
            case UI_MAP2_MAP_CLICKED: {
                UiMap2.MapClickedEvent mapClickedEvent = (UiMap2.MapClickedEvent)event;
                this.onMapClicked.fire(new Location(mapClickedEvent.getLocation().getLatitude(), mapClickedEvent.getLocation().getLongitude()));
                break;
            }
            case UI_MAP2_MARKER_CLICKED: {
                UiMap2.MarkerClickedEvent markerClickedEvent = (UiMap2.MarkerClickedEvent)event;
                Marker marker = (Marker)this.markersByClientId.get((Object)markerClickedEvent.getMarkerId());
                this.onMarkerClicked.fire(marker);
                break;
            }
            case UI_MAP2_ZOOM_LEVEL_CHANGED: {
                UiMap2.ZoomLevelChangedEvent zoomEvent = (UiMap2.ZoomLevelChangedEvent)event;
                this.zoomLevel = zoomEvent.getZoomLevel();
                this.onZoomLevelChanged.fire(Float.valueOf(this.zoomLevel));
                break;
            }
            case UI_MAP2_LOCATION_CHANGED: {
                UiMap2.LocationChangedEvent locationEvent = (UiMap2.LocationChangedEvent)event;
                this.location = Location.fromUiMapLocation(locationEvent.getCenter());
                UiMapArea displayedUiArea = locationEvent.getDisplayedArea();
                Area displayedArea = new Area(displayedUiArea.getMinLatitude(), displayedUiArea.getMaxLatitude(), displayedUiArea.getMinLongitude(), displayedUiArea.getMaxLongitude());
                this.onLocationChanged.fire(new LocationChangedEventData(this.location, displayedArea));
                break;
            }
            case UI_MAP2_SHAPE_DRAWN: {
                AbstractMapShape shape;
                UiMap2.ShapeDrawnEvent drawnEvent = (UiMap2.ShapeDrawnEvent)event;
                switch (drawnEvent.getShape().getUiObjectType()) {
                    case UI_MAP_CIRCLE: {
                        UiMapCircle uiCircle = (UiMapCircle)drawnEvent.getShape();
                        shape = new MapCircle(Location.fromUiMapLocation(uiCircle.getCenter()), uiCircle.getRadius());
                        break;
                    }
                    case UI_MAP_POLYGON: {
                        UiMapPolygon uiPolygon = (UiMapPolygon)drawnEvent.getShape();
                        shape = new MapPolygon(uiPolygon.getPath().stream().map(Location::fromUiMapLocation).collect(Collectors.toList()), null);
                        break;
                    }
                    case UI_MAP_POLYLINE: {
                        UiMapPolyline uiPolyLine = (UiMapPolyline)drawnEvent.getShape();
                        shape = new MapPolyline(uiPolyLine.getPath().stream().map(Location::fromUiMapLocation).collect(Collectors.toList()), null);
                        break;
                    }
                    case UI_MAP_RECTANGLE: {
                        UiMapRectangle uiRect = (UiMapRectangle)drawnEvent.getShape();
                        shape = new MapRectangle(Location.fromUiMapLocation(uiRect.getL1()), Location.fromUiMapLocation(uiRect.getL2()), null);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown shape type from UI: " + drawnEvent.getShape().getUiObjectType());
                    }
                }
                shape.setClientIdInternal(drawnEvent.getShapeId());
                this.shapesByClientId.put(drawnEvent.getShapeId(), shape);
                shape.setListenerInternal(this.shapeListener);
                this.onShapeDrawn.fire(shape);
                break;
            }
        }
    }

    public void addPolyLine(MapPolyline polyline) {
        this.addShape(polyline);
    }

    public void addShape(AbstractMapShape shape) {
        shape.setListenerInternal(this.shapeListener);
        this.shapesByClientId.put(shape.getClientIdInternal(), shape);
        this.queueCommandIfRendered(() -> new UiMap2.AddShapeCommand(this.getId(), shape.getClientIdInternal(), shape.createUiMapShape()));
    }

    public void removeShape(AbstractMapShape shape) {
        this.queueCommandIfRendered(() -> new UiMap2.RemoveShapeCommand(this.getId(), shape.getClientIdInternal()));
    }

    public void clearShapes() {
        this.queueCommandIfRendered(() -> new UiMap2.ClearShapesCommand(this.getId()));
    }

    public void setMarkerCluster(List<Marker<RECORD>> markers) {
        this.clusterMarkers = markers;
        markers.forEach(m -> this.markersByClientId.put((Object)this.clientIdCounter++, m));
        this.queueCommandIfRendered(() -> {
            UiMapMarkerCluster markerCluster = new UiMapMarkerCluster(this.clusterMarkers.stream().map(marker -> this.createUiMarkerRecord((Marker<RECORD>)marker, (Integer)this.markersByClientId.getKey(marker))).collect(Collectors.toList()));
            return new UiMap2.SetMapMarkerClusterCommand(this.getId(), markerCluster);
        });
    }

    public void clearMarkerCluster() {
        this.markersByClientId.values().removeAll(this.clusterMarkers);
        this.clusterMarkers.clear();
        this.queueCommandIfRendered(() -> new UiMap2.SetMapMarkerClusterCommand(this.getId(), new UiMapMarkerCluster(Collections.emptyList())));
    }

    private Template getTemplateForRecord(Marker<RECORD> record, TemplateDecider<Marker<RECORD>> templateDecider) {
        Template template = templateDecider.getTemplate(record);
        if (template != null && !this.templateIdsByTemplate.containsKey(template)) {
            String uuid = "" + this.templateIdCounter++;
            this.templateIdsByTemplate.put(template, uuid);
            this.queueCommandIfRendered(() -> new UiMap2.RegisterTemplateCommand(this.getId(), uuid, template.createUiTemplate()));
        }
        return template;
    }

    public String getBaseApiUrl() {
        return this.baseApiUrl;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getStyleUrl() {
        return this.styleUrl;
    }

    public void setStyleUrl(String styleUrl) {
        this.styleUrl = styleUrl;
        this.queueCommandIfRendered(() -> new UiMap2.SetStyleUrlCommand(this.getId(), styleUrl));
    }

    public void setZoomLevel(int zoomLevel) {
        this.zoomLevel = zoomLevel;
        this.queueCommandIfRendered(() -> new UiMap2.SetZoomLevelCommand(this.getId(), (float)zoomLevel));
    }

    public void setLocation(Location location) {
        this.setLocation(location, 2000L, 3);
    }

    public void setLocation(double latitude, double longitude) {
        this.setLocation(new Location(latitude, longitude));
    }

    public void setLocation(Location location, long animationDurationMillis, int targetZoomLevel) {
        this.location = location;
        this.zoomLevel = targetZoomLevel;
        this.queueCommandIfRendered(() -> new UiMap2.SetLocationCommand(this.getId(), location.createUiLocation(), animationDurationMillis, (float)targetZoomLevel));
    }

    public void setLatitude(double latitude) {
        this.setLocation(new Location(latitude, this.location.getLongitude()));
    }

    public void setLongitude(double longitude) {
        this.setLocation(new Location(this.location.getLatitude(), longitude));
    }

    public float getZoomLevel() {
        return this.zoomLevel;
    }

    public Location getLocation() {
        return this.location;
    }

    public void addMarker(Marker<RECORD> marker) {
        int clientId = this.clientIdCounter++;
        this.markersByClientId.put((Object)clientId, marker);
        this.queueCommandIfRendered(() -> new UiMap2.AddMarkerCommand(this.getId(), this.createUiMarkerRecord(marker, clientId)));
    }

    public void removeMarker(Marker<RECORD> marker) {
        Integer clientId = (Integer)this.markersByClientId.removeValue(marker);
        if (clientId != null) {
            this.queueCommandIfRendered(() -> new UiMap2.RemoveMarkerCommand(this.getId(), clientId.intValue()));
        }
    }

    public void clearMarkers() {
        this.markersByClientId.clear();
        this.queueCommandIfRendered(() -> new UiMap2.ClearMarkersCommand(this.getId()));
    }

    public void fitBounds(Location southWest, Location northEast) {
        this.location = new Location((southWest.getLatitude() + northEast.getLatitude()) / 2.0, (southWest.getLongitude() + northEast.getLongitude()) / 2.0);
        this.queueCommandIfRendered(() -> new UiMap2.FitBoundsCommand(this.getId(), southWest.createUiLocation(), northEast.createUiLocation()));
    }

    public Template getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultMarkerTemplate(Template defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public TemplateDecider<Marker<RECORD>> getTemplateDecider() {
        return this.templateDecider;
    }

    public void setMarkerTemplateDecider(TemplateDecider<Marker<RECORD>> templateDecider) {
        this.templateDecider = templateDecider;
    }

    public PropertyProvider<RECORD> getMarkerPropertyProvider() {
        return this.markerPropertyProvider;
    }

    public void setMarkerPropertyProvider(PropertyProvider<RECORD> propertyProvider) {
        this.markerPropertyProvider = propertyProvider;
    }

    public void setMarkerPropertyExtractor(PropertyExtractor<RECORD> propertyExtractor) {
        this.setMarkerPropertyProvider(propertyExtractor);
    }

    public boolean isDisplayAttributionControl() {
        return this.displayAttributionControl;
    }

    public void setDisplayAttributionControl(boolean displayAttributionControl) {
        this.displayAttributionControl = displayAttributionControl;
    }
}

