/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.teamapps.ux.i18n.TranslationProvider;

public class RankingTranslationProvider
implements TranslationProvider {
    private List<TranslationProvider> translationProviders = new ArrayList<TranslationProvider>();

    public void addTranslationProvider(TranslationProvider translationProvider) {
        this.translationProviders.add(0, translationProvider);
    }

    @Override
    public List<Locale> getLanguages() {
        return this.translationProviders.stream().flatMap(provider -> provider.getLanguages().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    public List<String> getKeys() {
        return this.translationProviders.stream().flatMap(provider -> provider.getKeys().stream()).distinct().collect(Collectors.toList());
    }

    @Override
    public String getTranslation(String key, Locale locale) {
        for (TranslationProvider translationProvider : this.translationProviders) {
            String translation = translationProvider.getTranslation(key, locale);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }

    @Override
    public String getTranslation(String key, List<Locale> acceptedLanguages) {
        for (TranslationProvider translationProvider : this.translationProviders) {
            String translation = translationProvider.getTranslation(key, acceptedLanguages);
            if (translation == null) continue;
            return translation;
        }
        return null;
    }
}

