/*
 * Decompiled with CFR 0.152.
 */
package org.teamapps.ux.component.grid.layout;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.teamapps.dto.UiFloatingComponentGridPlacement;
import org.teamapps.dto.UiGridPlacement;
import org.teamapps.ux.component.Component;
import org.teamapps.ux.component.grid.layout.AbstractGridPlacement;
import org.teamapps.ux.component.grid.layout.FloatingComponentGridPlacementItem;

public class FloatingComponentGridPlacement
extends AbstractGridPlacement {
    private List<FloatingComponentGridPlacementItem> items = new ArrayList<FloatingComponentGridPlacementItem>();
    private boolean wrap;
    private int horizontalSpacing = 5;
    private int verticalSpacing = 3;

    public FloatingComponentGridPlacement() {
    }

    public FloatingComponentGridPlacement(int row, int column, List<FloatingComponentGridPlacementItem> items) {
        super(row, column);
        this.items = items;
    }

    public UiFloatingComponentGridPlacement createUiGridPlacement() {
        List items = this.items.stream().map(floatingField -> floatingField.createUiFloatingComponentGridPlacementItem()).collect(Collectors.toList());
        UiFloatingComponentGridPlacement uiPlacement = new UiFloatingComponentGridPlacement(items).setWrap(this.wrap).setVerticalSpacing(this.verticalSpacing).setHorizontalSpacing(this.horizontalSpacing);
        this.mapAbstractGridPlacementUiProperties((UiGridPlacement)uiPlacement);
        return uiPlacement;
    }

    @Override
    public List<Component> getComponents() {
        return this.items.stream().map(item -> item.getComponent()).collect(Collectors.toList());
    }

    public List<FloatingComponentGridPlacementItem> getItems() {
        return this.items;
    }

    public void setComponents(List<FloatingComponentGridPlacementItem> components) {
        this.items = components;
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public void setHorizontalSpacing(int horizontalSpacing) {
        this.horizontalSpacing = horizontalSpacing;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public void setVerticalSpacing(int verticalSpacing) {
        this.verticalSpacing = verticalSpacing;
    }
}

